#ifndef H_LPBERKELEYDBREADER
#define H_LPBERKELEYDBREADER

#include <string.h>

#include "lpsong.h"
#include "lpdatabasereader.h"

using namespace std;

class QFile;
class Db;
class DbEnv;
class LPDatabaseIterator;

/*
 * A Berkeley DB database reader / writer
 */
class LPBerkeleyDBReader : public LPDatabaseReader
{
	//friend class LPBDatabaseIterator;
public:
    LPBerkeleyDBReader(string filename);
	~LPBerkeleyDBReader();
	void flush(); //quicksave?? ensures persistency
	void compact(); //saves, compacts.. whatever

	void store(Song song);
	void remove(Song song);
	Song retrieve(string key);

	bool inDatabase(string key);
	int getSize();

    LPDatabaseIterator* iterator();

private:
    int getVersion();
    void setVersion(int v);
    static void readData(char*,Song*);
    class LPBerkeleyDBIterator;
    friend class LPBerkeleyDBIterator;
    
    Db* db;
    DbEnv* dbenv;
};

#endif
