#ifndef H_LPDBASEMREADER
#define H_LPDBASEMREADER

#include <fstream>
#include <iostream>
#include <vector>

#include "absutil.h"
#include "lpsong.h"
#include "lpdatabasereader.h"
#include "lpdatabaseiterator.h"

#include <qstring.h>
#include <qdatetime.h>
#include <qdom.h>
#include <qmap.h>
#include <qthread.h>
#include <qfile.h>

using namespace std;

/** LPDatabaseMagicReader: a safer databasereader with low memory needs
 * this class is deprecated!
 */
class LPDatabaseMagicReader : public LPDatabaseReader
{
	friend class LPDatabaseIterator;
public:
	LPDatabaseMagicReader(string filename);
	~LPDatabaseMagicReader();

	void flush(); //quicksave?? ensures persistency
	void compact(); //saves, compacts.. whatever

	/** stores the given song description based on the key of the song */
	void store(Song song);
	void remove(Song song);
	/** looks up the song in the database */
	Song retrieve(string key);

	/** returns true when there is a song description in the database */
	bool inDatabase(string key) ;
	/** gives an estimate of the number of song descriptions in the database */
	int getSize();

	void resetPosition();
    LPDatabaseIterator* iterator();
private:
	/** if null, sets default name and position */
	void setFile(QFile* file);
	bool initFile(string filename);
	QFile* getFile() const;
	void test();
	bool quickLoad();
	void fullLoad();
	void open(string filename);
	void close();

	//database filename
	string _filename;

	//these work with setFile/getFile
	Song readRecord();
	string skipRecord();
	void writeRecord(Song);
	
	//these don't
	bool getWriteMagic(QFile*);
	void setWriteMagic(QFile*);
	bool getReadMagic(QFile*);
	void setReadMagic(QFile*);

	QFile* _file;
	QFile* _origFile;
	//qt hashmap
	QMap<string,Song> *_base;
	QMap<string,long> *_filePointers;
	QMutex dbAccess;

	char MAGIC_READ_MARKER[2];
	char MAGIC_WRITE_MARKER[2];
	int _lastwritemarker;
    
    class LPMagicDBIterator : public LPDatabaseIterator
    {
      public:
        LPMagicDBIterator(LPDatabaseMagicReader* reader);
        void reset();
        Song next();
        bool atEnd();
                                       
      private:
        //database filename
        QFile* _file;
        LPDatabaseMagicReader* _reader;
    };  
    
    friend class LPMagicDBIterator;
};
#endif
