#ifndef H_LPDBASEPREADER
#define H_LPDBASERPEADER

#include <fstream>
#include <iostream>
#include <vector>

#include "lpdatabasereader.h"
#include "lpdatabaseiterator.h"
#include "absutil.h"
#include "lpsong.h"

#include <qstring.h>
#include <qdatetime.h>
#include <qdom.h>
#include <qmap.h>
#include <qthread.h>
#include <qfile.h>

using namespace std;

class QFile;

/** LPDatabasePersistentReader: a databasereader with low memory needs 
 * this class is deprecated
 */
class LPDatabasePersistentReader : public LPDatabaseReader
{
public:
	LPDatabasePersistentReader(string filename);
	~LPDatabasePersistentReader();

	void flush(); //quicksave?? ensures persistency
	void compact(); //saves, compacts.. whatever

	/** stores the given song description based on the key of the song */
	void store(Song song);
	void remove(Song song);
	/** looks up the song in the database */
	Song retrieve(string key);
    
	/** returns true when there is a song description in the database */
	bool inDatabase(string key) ;
	/** gives an estimate of the number of song descriptions in the database */
	int getSize();

    LPDatabaseIterator* iterator();
	void resetPosition();

private:
	/** if null, sets default name and position */
	void setFile(QFile* file);
	bool initFile(string filename);
	QFile* getFile() const;

	void test();
	bool quickLoad();
	void fullLoad();

	//database filename
	string _filename;

	Song readRecord();
	void writeRecord(Song);

	QFile* _file;
	QFile* _origFile;
	//qt hashmap
	QMap<string,Song> *_base;
	QMap<string,long> *_filePointers;
	QMutex dbAccess;

    class LPPersistentDBIterator : public LPDatabaseIterator
    {
      public:
        LPPersistentDBIterator(LPDatabasePersistentReader* reader);
        void reset();
        Song next();
        bool atEnd();
                                       
      private:
        //database filename
        QFile* _file;
        LPDatabasePersistentReader* _reader;
    };  
    
    friend class LPPersistentDBIterator;
};

#endif
