/** LongPlayer - cross-platform multimedia queuer
 *  Class written by Jeroen Coekaerts
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_LPDBASEXMLREADER
#define H_LPDBASEXMLREADER

#include "lpdatabase.h"
#include "lpsong.h"
#include <string>
#include <qxml.h>

using namespace std;
/**
* Reads XML exported databases back into the database.
*/
class LPDatabaseXMLReader : public QXmlDefaultHandler
{

public:
	LPDatabaseXMLReader(LPDatabase* database);
	~LPDatabaseXMLReader();
	/** Document start event (ContentHandler interface) */
	bool startDocument();
	/** Element start event  (ContentHandler interface) */
	bool startElement( const QString&, const QString&, const QString& ,
		const QXmlAttributes& );
	/** Element end event  (ContentHandler interface) */
	bool endElement( const QString&, const QString&, const QString& );
	/** Text data event  (ContentHandler interface) */
	bool characters ( const QString & ch );

private:
	LPDatabase* _database;
	Song _song; //tmp song
	string _buffer;// tmp character data
};

//NOTE: QXmlDefaultHandler is actually also an QXmlErrorHandler.

class LPDatabaseXMLReaderErrorHandler : public QXmlErrorHandler
{
public:

LPDatabaseXMLReaderErrorHandler();
bool warning ( const QXmlParseException & exception );
bool error ( const QXmlParseException & exception );
bool fatalError ( const QXmlParseException & exception );
QString errorString ();
};

#endif
