/** LongPlayer - cross-platform multimedia queuer
 *  Class written by Jeroen Coekaerts
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#include "lpdatabasexmlwriter.h"

#include <iostream>
#include <vector>
#include <algorithm>

#include <qregexp.h>
#include <qtextcodec.h>

//TODO: remove all QT stuff (Jeroen)
LPDatabaseXMLWriter::LPDatabaseXMLWriter(string filename)
{
//	file = new QFile(QString::fromLocal8Bit(filename.c_str()));
/*	if (!file->open(IO_WriteOnly))
	{
		open = false;
		logError(string("LPDatabase::exporting database to XML. Failed to open file (for writing):")+filename);
		return; //ABORT!
	}
*/
	open = true;
	_f = new ofstream(filename.c_str());
#if QT_VERSION / 100 > 2
	string encoding = QTextCodec::codecForLocale()->mimeName();
	*_f << string("<?xml version='1.0' encoding='"+encoding+"' ?>\n"); //TODO export to utf8 ?
#else
	*_f << string("<?xml version='1.0'?>\n"); //TODO sorry, screwed if you need encoding type, QTextCodec::codecForLocale()->name() has spaces etc.. eg encoding='ISO 8859-15'
#endif
   *_f << string(
		"<!DOCTYPE LPlayerDB [<!ELEMENT LPlayerDB (song*)>" "\n"
		"<!ELEMENT song (key, name, filename, date, times, score, length)>" "\n"
		"<!ELEMENT key (#PCDATA)>" "\n"
		"<!ELEMENT name (#PCDATA)>" "\n"
		"<!ELEMENT filename (#PCDATA)>" "\n"
		"<!ELEMENT date (#PCDATA)>" "\n"
		"<!ELEMENT times (#PCDATA)>" "\n"
		"<!ELEMENT score (#PCDATA)>" "\n"
		"<!ELEMENT length (#PCDATA)>" "\n"
		"]>" "\n");
	*_f << "<LPlayerDB>" << "\n";


}

void LPDatabaseXMLWriter::close()
{
	*_f << "</LPlayerDB>" "\n";
	_f->close();
	open = false;
}

bool LPDatabaseXMLWriter::isOpen()
{
	return open;
}

void LPDatabaseXMLWriter::writeSong(Song* song)
{
	*_f <<
	" <song>\n" <<
	"  <key>" << xmlise(song->getKey()) << "</key>\n" <<
	"  <name>"<<xmlise(song->getName())<<"</name>\n" <<
	"  <filename>"<<xmlise(song->getFilename())<<"</filename>" "\n" <<
	"  <date>"<<absUtil::its(song->getDate())<<"</date>\n" <<
	"  <times>"<<absUtil::its(song->getTimes())<<"</times>\n" <<
	"  <score>"<<absUtil::its(song->getLike()+5)<<"</score>\n" <<
	"  <length>"<<absUtil::its(song->length())<<"</length>\n" <<
	" </song>\n";
}

string LPDatabaseXMLWriter::xmlise(string input)
{
	string::iterator it;
	it = input.begin();
	vector <char> buffer;
	while(it != input.end() ) {
		switch(*it){
		case '<':
			buffer.push_back('&');buffer.push_back('l');buffer.push_back('t');buffer.push_back(';');
			break;
		case '>':
			buffer.push_back('&');buffer.push_back('g');buffer.push_back('t');buffer.push_back(';');
			break;
		case '&':
			buffer.push_back('&');buffer.push_back('a');buffer.push_back('m');buffer.push_back('p');buffer.push_back(';');
			break;
		case '\'':
			buffer.push_back('&');buffer.push_back('a');buffer.push_back('p');buffer.push_back('o');buffer.push_back('s');buffer.push_back(';');
			break;
		case '"':
			buffer.push_back('&');buffer.push_back('q');buffer.push_back('u');buffer.push_back('o');buffer.push_back('t');buffer.push_back(';');
			break;
		default:
			buffer.push_back(*it);
		}
		it++;
  }
	buffer.push_back('\0');
	//VC++ can't handle non constant sized arrays
	char* result =  new char[buffer.size()];
	copy(buffer.begin(),buffer.end(),result);
	string stringres = string(result);
	delete result;
  return stringres;
}



LPDatabaseXMLWriter::~LPDatabaseXMLWriter()
{
	if(isOpen()){
		close();
	}
	delete(_f);
}

