#include "lpdirview.h"
#include <qlistview.h>
#include <qdir.h>

LPDirView::LPDirView()
{
	this->addColumn("Name");
	const QFileInfoList* drives =  QDir::drives();
   	QFileInfoListIterator driveit(*drives);
    QFileInfo *di;                          // pointer for traversing
    while ( (di=driveit.current()) ) 
	{ 
		QListViewItem *item = new QListViewItem(this,di->dirPath());
		QDir d(di->dirPath());
        d.setFilter( QDir::Dirs);
        const QFileInfoList *list = d.entryInfoList();
        if (list)
        {
        	QFileInfoListIterator it( *list );      // create list iterator
        	QFileInfo *fi;                          // pointer for traversing
        	while ( (fi=it.current()) ) 
			{ 
				addDir(item,fi->dirPath());
            	++it;                               // goto next list element
        	}
        }
        ++di;                               // goto next list element
	}
		
}
void LPDirView::addDir(QListViewItem* /*base*/, QString /*dir*/)
{
}
