/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef LPFPLAYLISTS_H
#define LPFPLAYLISTS_H
#include "lpformplaylistsbase.h"

class LPApp;
class CompositePlaylist;

class LPFormPlaylists : public LPFormPlaylistsBase
{
	Q_OBJECT

public:
	LPFormPlaylists(LPApp* app, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags f = 0 );

	//inherited slots
	void apply();
    void PlaylistAddDir();
    void PlaylistCreate();
    void PlaylistSave();
    void PlaylistSaveAs();
    void PlaylistSelectDir();
    void PlaylistRemoveDir();
    void PlaylistRemove();
    void PlaylistToggleSubDirs();
    void PlaylistSelect();
	void PlaylistAddM3U();

	//when quitting 
	void accept();
	void reject();

	void checkButtons();

private:
	void refreshPlaylists();
	LPApp* getApp();
	LPApp* _app;
	CompositePlaylist* _playlist;	
};

#endif

