/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef LPSEARCHIMP_H
#define LPSEARCHIMP_H

#include "lpformsearchbase.h"
#include "lpsong.h"

#include <qlistview.h>
#include <qtimer.h>
#include <qthread.h>
#include <vector>
#include <string>

#include "lplistener.h"

class LPApp;
class LPPlaylistIterator;
class LPSongFilter;
class Playlist;
class ThreadedCommand;
class GenreConstraintWidget;

using namespace std;

class LPFormSearch : public LPFormSearchBase, LPListener
{
	Q_OBJECT
public:
	LPFormSearch( LPApp* p, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags f = 0 );
	~LPFormSearch();

	//when quitting LPlayer
	void accept();
	void reject();
	
	//inherited slots
    virtual void random();
    virtual void rating();
    virtual void times();	

    virtual void heard();
    virtual void startSearch();
    virtual void cancelSearch();
	
    virtual void copySongs();
    virtual void deleteSongs();
    virtual void playSongs();
    virtual void queueSongs();
    virtual void playSong(QListViewItem*);
    virtual void saveM3U();
	
	void notify(int i=0);

	bool event(QEvent* e);

public slots:
	virtual void checkBuilt();
	virtual void searchOneSong();

private:
	int getFilterType(QString);
	//returns selected or all found songs
	vector<string> getFoundSongs();
    int fullpathcolid;
	int songkeycolid;
	void makeSongListViewItem(QListView* list, Song sng,QListViewItem* item =0);
	void checkButtons();
	void refreshPlaylists();

	GenreConstraintWidget* _genreWidget;
	QListViewItem* _lastItem;
    LPApp*  getApp();
	LPApp* _app;
	Playlist* _listp;
	LPSongFilter* _filter;
	LPPlaylistIterator* _iterator;
	ThreadedCommand* _builder;
	QTimer* _timer;
	QMutex searchStep;
	QMutex timerMutex;
	int stopMB, stopSongs;
	int currSongs, currMB;
};

class SearchedSongItem : public QListViewItem
{
    public:
       SearchedSongItem(QListView* list, Song sng, QListViewItem* after);
       SearchedSongItem(QListView* list, Song sng);
       //sets song and updates fields
       void setSong(Song sng);
    private:
       int fullpathcolid;
	   int songkeycolid;
};

#endif

