#include "lpformstartup.h"
#include "abslog.h"

#include "lpglobal.h"
#include "lpguihandler.h"

#include <qstatusbar.h>
#include <qlabel.h>
#include <qlayout.h>

/*
 *  Constructs a LPFormStartup which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
LPFormStartup::LPFormStartup(QWidget* parent,  const char* name, bool modal, WFlags fl )
    : LPFormStartupBase( parent, name, modal, fl )
{
//	statusbar = new QStatusBar(this);
//	statusbar->setSizeGripEnabled(false);
	//startupBaseLayout->addWidget(statusbar);
	txtSlogan->setText(""
		"Copyright (c) 2001-2004 by Andrew Wils\n"
		"Distributed under the GNU General Public License"
		);

}
void LPFormStartup::reject() { }
void LPFormStartup::accept() { }
void LPFormStartup::hide() { LPFormStartupBase::hide(); }
void LPFormStartup::show() { LPFormStartupBase::show(); }

LPFormStartup::~LPFormStartup() { }

bool LPFormStartup::event(QEvent* e)
{
	if (e->type() ==  QEvent::User ) 
	{
		if (LPGUIEvent *lpe = (LPGUIEvent*)(e) )
		{
			int type = lpe->getType();
			switch (type)
			{
			case LPGUIEvent::LPWARNING:
				TextLabel1->setText(lpe->getMessage().c_str());
				break;
			case LPGUIEvent::LPERROR:
				TextLabel1->setText(lpe->getMessage().c_str());
			    logError(lpe->getMessage());
				break;		
			}
			return true;
		}
	}
	return LPFormStartupBase::event(e);
}
