/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef pktglob
#define pktglob

//uncomment to use kde libs
//#define _KDE_

// Disable the warning "identifier was truncated to '255' characters in the debug information"
#ifdef _MSC_VER
#pragma warning(disable:4786)
#endif

#include <string>
#define LPVERSION #include "lpversion"

using namespace std;
class absLog;

/** stores UI elements and variables for global debugging messages
 */
class globalclass {
public:
	static absLog* getLogger();
	static void setLogger(absLog* _logger);
private:
	static absLog* _logger;
	
};

bool doSetProgress(int);
void doInitProgress(string text, int steps);
void doEndProgress();

/** normal debugging message */
void logDebug(int text);
void logDebug(string text);

/** displays a message to the user */
void logMessage(string text);

/** normal debugging message (purely informative, high entertainment value) */
void logInfo(string text, int=3000);

/** severe error message  */
void logError(string text);

/** unanticipated error messages */
void logOops(string text);

/** recoverable error message  */
void logWarning(string text);

void logBusy(string, bool);
void logReady(string);

void doTest(bool b, string s);
void doAssert(bool b, string s);

#endif
