/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_LONGPLAYER
#define H_LONGPLAYER

#include <iostream>
#include <vector>
#include "lplistener.h"
#include "absutil.h"
#include "lpsong.h"
#include "directoryplaylist.h"
#include "lpsettings.h"

class LPDatabase; class LPSettings; class absPlayer; class LPFifo; class fileWriter; class QueueBuilder; class PlaylistReader;

 /*  the LPlayer class brings most lplayer-lib modules together
 */
class LPlayer : public LPListener {
public:
	static IntSetting SettingEffort;

	/** creates a new LPlayer component
	 *	use init() and ready() function to initialize and
	 *	to check whether lplayer is ready to use.
	 */
	LPlayer(LPSettings* settings);
	virtual ~LPlayer();

	/* starts initialization of all modules:
	 * - database
	 * - 
	 */
	void init();
	/* true when all modules have been initialized,
	 * thread-safe with regard to init() */
	bool ready();

	LPDatabase* getDatabase() const;
	LPSettings* getSettings() const;
	PlaylistReader* getPlaylists() const;
	absPlayer* getPlayer() const;

	/** should be called to exit LPLayer and properly destruct the modules */
	void quit();

	/** returns the song that is currently playing */
	Song currentSong() ;
	
	/** call-back function the absPlayer should call when a new song is playing */
 	void notify(int i=0);

	/** enables you to subscribe to get a notification for a new song */
	void subscribe(LPListener* gui);

	void test();

	Playlist* getBuiltPlaylist();
	QueueBuilder* getQueueBuilder();

private:
	/** checks whether lplayer needs to refresh the current playlist */
	bool shouldBuild();

	void notifyListeners();
	void checkFirstTime();

	vector<LPListener*> _listeners;

	void setCurrentSong(Song song);
	
	LPSettings* _settings;
	absPlayer* _player;
	LPDatabase* _database;
	PlaylistReader* _playlists;
	QueueBuilder* _queuebuilder;

	LPListener* _builder;
	//current playlist
	CompositePlaylist* _queueList;
	//when was it last built
	int _queueListTimeStamp;
	fileWriter* _writer;

	//sync stuff
	QMutex change;
	QMutex initing;

	Song _currsong;

	bool _isRunning;
	bool flagQuit;
	QMutex setFlag;
};

#endif
