#include "lpnogui.h"
#include "lpfactory.h"
#include "lpsettings.h"
#include "lplayer.h"
#include "lpdatabase.h"
#include "lpguihandler.h"
#include "lpsong.h"

#include <qfileinfo.h>
#include <qthread.h>

#include <iostream>
//#include <curses.h>
//#include <stdlib.h>

LPNoGUI::LPNoGUI(LPSettings* settings) : _quit(false), _settings(settings) {
#if QT_VERSION / 100 > 2
	QThread::initialize(); // no, we have to initialize threads ourselves
#endif
	((LogQt*)(globalclass::getLogger()))->setOutput(this);
	_lplayer = LPFactory::getFactory()->getLPlayer();
}

LPSettings* LPNoGUI::getSettings() { return _settings; }
LPlayer* LPNoGUI::getLPlayer() { return _lplayer; }

void LPNoGUI::quit() {
	_quit = true;
}

void LPNoGUI::start() {
	cout << "Welcome to LongPlayer.\n";
	getLPlayer()->init();
 	getLPlayer()->subscribe(this);

	cout << "type x (quit), q(ueue), + or -\n";
 	char t = 0;
 	Song s;
	while (!_quit) {
		if ((t == 'h') || (t == '?'))
			cout << "type x (quit), q(ueue), + or -\n";
		t = getchar();
		if (t == 'q') {
		//FIXME
		//	Queue q(getLPlayer(), true); q.start();
		}
		else if (t == '+') {
			s = getLPlayer()->currentSong();
			s.setLike(s.getLike()+1);
			getLPlayer()->getDatabase()->store(s,false);
		}
		else if (t == '-') {
			s = getLPlayer()->currentSong();
			s.setLike(s.getLike()-1);
			getLPlayer()->getDatabase()->store(s,false);
		}
		else if (t == 'x') _quit = true;
  }
  getLPlayer()->quit();
}
bool LPNoGUI::event(QEvent* e) {
	if (e->type() ==  QEvent::User ) {
		if (LPGUIEvent *lpe = (LPGUIEvent*)(e) ) {
			int type = lpe->getType();
			switch (type) {
			case LPGUIEvent::LPDEBUG:
		//		cout <<  lpe->getMessage().c_str() << "\n";
				break;
			case LPGUIEvent::LPINFO:
				cout <<  lpe->getMessage().c_str() << "\n";
				break;
			case LPGUIEvent::LPWARNING:
				cout <<  lpe->getMessage().c_str() << "\n";
				break;
			case LPGUIEvent::LPERROR:
				cout <<  lpe->getMessage().c_str() << "\n";
				break;		
			}
			return true;
		}
	}
//	else return QObject::event(e);/	*/
	return false;
} 

void LPNoGUI::notify(int) {
	Song sng;
	sng = getLPlayer()->currentSong();
	string name, like, ago, times, length; int date = 0;
	name = sng.getName();
	if (sng.getFilename().empty()) name = "unknown filename";
	if (name.empty()) name = sng.getFilename();
	if (sng.getOldDate() || sng.getDate()) {
		if (sng.getOldDate() )
			date = sng.getOldDate();
		else
		if (sng.getDate())
			date = sng.getDate();
		ago = absUtil::longTimeSpan(absUtil::getUtil()->date() - date);
		ago += " ago";
	}
	else {		
		ago = "first time";
	}
	if (sng.getLike()) like = absUtil::its(sng.getLike() + 5) + "/10";
	else like = "neutral";
	if (sng.length() > 1) length = absUtil::shortTimeSpan(sng.length());
		else length = "unknown";
	times = (sng.firstTime()) ? "first time" : absUtil::its(sng.getTimes()).c_str();
	QFileInfo info(sng.getFilename().c_str());
	if (!sng.getFilename().empty()) {
	cout << "***************************************************\n";
	cout << sng.getName() + " " +
		string(info.dirPath().latin1()) + "" +
		absUtil::its(sng.getLike() + 5) + string("/10") +
		string(" size: ") + absUtil::its(sng.size() / 1024) + string("kb") +
		string(" length: ") + absUtil::shortTimeSpan(sng.length()) + " heard " + ago + "\n";
	cout << "***************************************************\n";
	}
		
}
