/*  LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_LPSETTINGS
#define H_LPSETTINGS

#include "lpglobal.h"
#include "lpsong.h"

#include <qdom.h>

#include <vector>

/** provides settings for LPlayer modules */
class LPSettings;

class IntSetting {
	public:
		inline IntSetting(string cat, string setting) : _cat(cat), _setting(setting), _dval(0) { }
		inline IntSetting(string cat, string setting, int dval) : _cat(cat), _setting(setting), _dval(dval) { }
		inline void setType(string cat, string setting) { _cat = cat; _setting = setting; }
		inline string getCategory() { return _cat; }
		inline string getName() { return _setting; }
		inline int getDefault() { return _dval; }
	private:
		string _cat;
		string _setting;
		int _dval;
}; 

class FloatSetting {
	public:
		inline FloatSetting(string cat, string setting, float dval) : _cat(cat), _setting(setting), _dval(dval) { }
		inline void setType(string cat, string setting) { _cat = cat; _setting = setting; }
		inline string getCategory() { return _cat; }
		inline string getName() { return _setting; }
		inline float getDefault() { return _dval; }
	private:
		string _cat;
		string _setting;
		float _dval;
}; 

class StringSetting {
	public:
		inline StringSetting(string cat, string setting, string dval = "") : _cat(cat), _setting(setting), _dval(dval) { }
		inline void setType(string cat, string setting) { _cat = cat; _setting = setting; }
		inline string getCategory() { return _cat; }
		inline string getName() { return _setting; }
		inline string getDefault() { return _dval; }
	private:
		string _cat;
		string _setting;
		string _dval;
}; 

class LPSettings {
public:
    LPSettings();
    LPSettings(string ini);
    ~LPSettings();
    
    void loadSettings(string ini);
	void checkInit();
    void revert();
	
	//Qt function homedir often returns c: in windows
	static string getLPHomeDir();
	static string getResourceDir();

    /** tests whether a setting exists, if not, sets */
	void checkSetting(string category, string name, string value);
    void checkISetting(string category, string name, int value);
    void checkFSetting(string category, string name, float value);
	
    void setSetting(StringSetting, string value, bool persist=true);
    void setSetting(IntSetting, int value, bool persist=true);
    void setSetting(FloatSetting, float value, bool persist=true);

	void setSetting(string category, string name, string value, bool persist=true);
    void setISetting(string category, string name, int value, bool persist=true);

	/* if not exists, returns default value */
    string getSetting(StringSetting);
    float getSetting(FloatSetting);
    int getSetting(IntSetting);

    string getSetting(string category, string name);
    int getISetting(string category, string name);

    /** returns true if setting exists */
    bool testSetting(string category, string name);
    bool testSetting(StringSetting);
    bool testSetting(IntSetting);
    bool testSetting(FloatSetting);

    void add(string category, string name, int value=1);
    void save();
private:
    void setFSetting(string category, string name, float value, bool persist=true);
    float getFSetting(string category, string name);
	void init();
	static LPSettings* _singleton;
	string _resourceDir;

    QDomDocument _doc;
    QDomDocument _rtdoc; //runtime settings (non persistent)
};
#endif
