#include "lpwac.h"

#include "resource.h"

#include "../../studio/api.h"
#include "../../bfc/svc_enum.h"
//#include "../../bfc/bitmap.h"
// Window creation services includes.
#include "../../studio/services/creators.h"
#include "../../bfc/wndcreator.h"

#include "lpwindowmainwa3.h"

#include <qapplication.h>
#include "lpsettings.h"
#include "logwa.h"
#include "lpfactory.h"
#include "winamp3.h"
#include "logwa.h"
#include "lplistener.h"
#include "utilwin.h"
#include "lpfacade.h"

WACLPlayer wac;
WACPARENT *the = &wac;

// LongPlayer GUID for Winamp 3
// {0D23845F-054B-4d52-AE5A-BA168AFC73C2}
static const GUID guid = 
{ 0xd23845f, 0x54b, 0x4d52, { 0xae, 0x5a, 0xba, 0x16, 0x8a, 0xfc, 0x73, 0xc2 } };


WACLPlayer::WACLPlayer() : WACPARENT("LongPlayer WAC") {
	//register...
	// thinger icon
	registerService(new WndCreateCreatorSingle< CreateBucketItem<LPWindowMainWA3> >);
	// main menu entry
	registerAutoPopup(getGUID(), getName());
	// main window
	registerService(new WndCreateCreatorSingle< CreateWndByGuid<LPWindowMainWA3> >);
	// skinfile
	registerSkinFile("wacs/xml/LongPlayer/component_skin.xml");
}

WACLPlayer::~WACLPlayer() {
}

GUID WACLPlayer::getGUID() {
	return guid;
}

void WACLPlayer::onCreate() {
	WACPARENT::onCreate();

	LPSettings* settings = new LPSettings();
	int n =0;
	QApplication app(n,0);

	_amp = new Winamp3(api);
	// As we init, add this object to process Core Callback events.
	api->core_addCallback(0, _amp);
	absPlayer::setPlayer(_amp);
    _logger = new LogWA(true);
    _logger->setOutput(0);
    _logger->setWidget(0);
    _logger->setApplication(0);
    globalclass::setLogger(_logger);
    absUtil::setUtil(new Util());
	LPFactory::setLPFactory(new LPFactory(settings));
	LPFactory::getLPFactory()->createLPlayer();
}


void WACLPlayer::onDestroy() {
	//NO OUTPUT from now on...
	//delete _list; _list = NULL; //automatically?
    _logger->setListener(0);
	_logger->setOutput(0);

	api->core_delCallback(0, _amp);
	//also destroys
	LPFactory::getLPFactory()->getFacade()->quit();//TODO use callback of factory

	delete LPFactory::getLPFactory();
	LPFactory::setLPFactory(0);
	delete _logger;
	WACPARENT::onDestroy();
}
 
void WACLPlayer::runlevelcb_onStartup(){}
void WACLPlayer::runlevelcb_onAppRunning(){}
//TODO even this is TOO LATE, before this the playlist stuff has already been deregistered...
void WACLPlayer::runlevelcb_onShutdown(){ //onDestroy already has stuff disabled (e.g. endofplaylist in winamp3 class)
//kill it, goddammit
	_logger->setListener(0);
	_logger->setOutput(0);
}

