/* XPM for windows tray icon */
#include "lpicon.h"
#include "lpwindowmain.h"
#include "lpformstartup.h"
#include "lpsettings.h"
#include "lpdatabase.h"
#include "lpformprefs.h"
#include "lpformplaylists.h"
#include "lpformsearch.h"
#include "lpformabout.h"
#include "lpfactory.h"
#include "logqt.h"
#include "lpguihandler.h"
#include "lpglobal.h"
#include "lpapp.h"
#include "lplayer.h"
#include "absplayer.h"
#include "queuebuilder.h"
#include "genrewidget.h"

#ifndef _WS_WIN_
#ifdef _KDE_
#include <kmenubar.h>
#else
#include <qmenubar.h>
#endif
#else
#include <qmenubar.h>
#endif

#include <qpainter.h>
#include <qcombobox.h>
#include <qheader.h>
#include <qslider.h>
#include <qaccel.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qpopupmenu.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qlistview.h>
#include <qlistbox.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qinputdialog.h>
#include <qstatusbar.h>
#include <qdatetime.h>
#include <qfileinfo.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <qfileinfo.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <qpalette.h>
#include <qbrush.h>
#include <qtextview.h>

IntSetting LPWindowMain::SettingSplash("main", "splash",0);
IntSetting LPWindowMain::SettingTrim("mainwindow", "trim",1);
IntSetting LPWindowMain::SettingTrimVal("mainwindow", "trimval",20);
IntSetting LPWindowMain::SettingTray("mainwindow", "showtray",1);
IntSetting LPWindowMain::SettingTitleWidth("mainwindow", "titlewidth",100);
IntSetting LPWindowMain::SettingMinimal("mainwindow", "minimal",0);
IntSetting LPWindowMain::SettingX("mainwindow", "x");
IntSetting LPWindowMain::SettingY("mainwindow", "y");
IntSetting LPWindowMain::SettingHideOnMinimize("mainwindow", "hideonminimize",1);
IntSetting LPWindowMain::SettingHideOnClose("mainwindow", "hideonclose",0);
IntSetting LPWindowMain::SettingStartInTray("mainwindow", "startintray",0);
IntSetting LPWindowMain::SettingShowMain("mainwindow", "showmain",1);
IntSetting LPWindowMain::SettingShowCurrent("mainwindow", "showcurrent",1);
IntSetting LPWindowMain::SettingShowPlayed("mainwindow", "showplayed",1);
IntSetting LPWindowMain::SettingWidth("mainwindow", "height");
IntSetting LPWindowMain::SettingHeight("mainwindow", "width");
IntSetting LPWindowMain::SettingMediabar("mainwindow", "mediabar",1);
IntSetting LPWindowMain::SettingMainbar("mainwindow", "mainbar",1);

LPWindowMain::LPWindowMain(LPSettings* settings, QWidget* parent, const char* name, WFlags f )
	: LPWindowMainBase( parent, name, f ), _quitting(false), _lastSong(), _msgbusy(false), _minimalButton(0), _stateMinimal(false), _settings(settings)
{
    connect(genreMatrix,SIGNAL(genreChanged(int, int, int)),this,SLOT(setSelectedSongGenre(int, int, int)));
    connect(genreQMatrix,SIGNAL(constraintChanged(int, int, int,int)),this,SLOT(setQConstraint(int, int, int,int)));

	logDebug("UI::constructing main dialog.");

	//redirect information to this window
  	((LogQt*)(globalclass::getLogger()))->setOutput(this);
	((LogQt*)(globalclass::getLogger()))->setWidget(this);

	//start splash screen if necessary
    _splash = new LPFormStartup(0, 0, false,Qt::WStyle_Customize | WStyle_NoBorderEx);
    if (getSettings()->getSetting(SettingSplash)) _splash->show();
	qApp->processEvents();

	//start an LPApp
	setApp(new LPApp(getSettings()));

	//register so we can quit if the app asks it
	getApp()->subscribe(this);

	statusbar = statusBar();
	//requires set up LPApp
	createMenus();
	createToolbars();
	viewPlayedSongs->clear();
	viewQueuedSongs->clear();
	viewPlayedSongs->setSorting(0, false);
	viewPlayedSongs->setItemMargin(2);
	grpQueued->hide();

#ifdef _WS_WIN_
    //1.always on top option for windows windowmanager does not work with Qt2/Win :(
    //view->insertItem( "Always on top", this, SLOT(toggleAlwaysOnTop()),0,-1,6);
	_playlistsmenu = 0;
	tray = new TrayIcon( QPixmap( (const char**)lplayer_xpm ), "Click to show/hide LongPlayer", 0 );
    QObject::connect(tray,SIGNAL(clicked(const QPoint&)),this,SLOT(toggleShow()));
    if (getSettings()->getSetting(SettingTray)) tray->show();
#endif

	//process GUI settings
	LPSettings* s = getSettings();
	if (s->testSetting(SettingTitleWidth)) { 
		viewPlayedSongs->setColumnWidthMode ( 1, QListView::Manual );
		viewPlayedSongs->setColumnWidth ( 1, s->getSetting(SettingTitleWidth ));
	}
	if (s->getSetting(SettingMinimal)) _stateMinimal = true;

	setLayout();

	if (s->testSetting(SettingX) && s->testSetting(SettingY)) {
		int x = s->getSetting(SettingX);
		if (x > QApplication::desktop()->width()) x = QApplication::desktop()->width() - 100;
		int y = s->getSetting(SettingY);
		if (y > QApplication::desktop()->height()) y = QApplication::desktop()->height() - 100;
		if (y < 0) y = 0;
		move(x,y);
	}

	tip = new PlayedSongTip(viewPlayedSongs->viewport());
	//we're ready!
   connect(((LogQt*)(globalclass::getLogger()))->getApplication(), SIGNAL( aboutToQuit() ), this, SLOT( quit() ) );

	//deprecated
	//chkAnalyze->hide();

	//now we play the waiting game...
	//..
	//nah, the waiting game sucks, let's play hungry hungry hippo's!
	notify();
}

LPWindowMain::~LPWindowMain() {
  	((LogQt*)(globalclass::getLogger()))->setOutput(0);
    // no need to delete child widgets, Qt does it all for us
	// except for...
#ifdef _WS_WIN_
	tray->hide();
	delete tray;
#endif
	delete tip;
	delete _playedSongHandler;
}

LPApp* LPWindowMain::getApp() { return _app; }
void LPWindowMain::setApp(LPApp* app) { _app = app; }
LPSettings* LPWindowMain::getSettings() { return _settings; }
void LPWindowMain::createToolbars() {
	//toolbar icons
	QToolButton* tbutton;
	QString imgPrefix = QDir(
		QString::fromLocal8Bit(LPSettings::getResourceDir().c_str())
		).absPath();
	imgPrefix += "/images/";

	if (!QFile::exists(imgPrefix + "playnow.png"))
	{
		logError(
			"Cannot find image resources! Make sure they are present in: " +
			string(imgPrefix.local8Bit())
		);
	}

	_mainBar = new LPToolBar(getSettings(),"mainshowtoolbar", this,"LongPlayer toolbar");
	QToolBar* toolbar;

	toolbar = _mainBar;
	tbutton = new QToolButton(QPixmap(imgPrefix + "playnow.png"),"queue and play",0,this, SLOT(queue()),toolbar); tbutton->setAutoRaise(true);
	tbutton = new QToolButton(QPixmap(imgPrefix + "queue.png"),"queue and add",0,this, SLOT(enqueue()),toolbar); tbutton->setAutoRaise(true);
	tbutton = new QToolButton(QPixmap(imgPrefix + "rateup32.png"),"rate up",0,this, SLOT(incRatingCurrentSong()),toolbar); tbutton->setAutoRaise(true);
	tbutton = new QToolButton(QPixmap(imgPrefix + "ratedown32.png"),"rate down",0,this, SLOT(decRatingCurrentSong()),toolbar); tbutton->setAutoRaise(true);
#ifndef _WS_WIN_
	_minimalButton = new QToolButton(QPixmap(imgPrefix + "minimal.png"),"minimal view",0,this, SLOT(toggleMinimal()),toolbar); _minimalButton->setAutoRaise(true);
#endif
	addToolBar(_mainBar);

	_mediaBar = new LPToolBar( getSettings(),"mainshowmediabar",this,"MediaPlayer toolbar");
	toolbar = _mediaBar;
	tbutton = new QToolButton(QPixmap(imgPrefix + "previous.png"),"previous",0,this, SLOT(pprevious()),toolbar); tbutton->setAutoRaise(true);
	tbutton = new QToolButton(QPixmap(imgPrefix + "play.png"),"play",0,this, SLOT(pplay()),toolbar); tbutton->setAutoRaise(true);
	tbutton = new QToolButton(QPixmap(imgPrefix + "next.png"),"next",0,this, SLOT(pnext()),toolbar); tbutton->setAutoRaise(true);
	tbutton = new QToolButton(QPixmap(imgPrefix + "stop.png"),"stop",0,this, SLOT(pstop()),toolbar); tbutton->setAutoRaise(true);
	addToolBar(_mediaBar);

}

void LPWindowMain::createMenus() {
#ifndef _WS_WIN_
#ifdef _KDE_
    KMenuBar* menu = new KMenuBar( this );
#else
    QMenuBar* menu = new QMenuBar( this );
#endif
#else
    QMenuBar* menu = new QMenuBar( this );
#endif
    CHECK_PTR( menu );

    _playedSongHandler = new PlayedSongHandler(this); _playedSongHandler->setApp(getApp());
    connect( viewPlayedSongs, SIGNAL( rightButtonPressed(QListViewItem*,const QPoint&,int) ), _playedSongHandler, SLOT( viewPopup(QListViewItem*, const QPoint&) ) );

	//menus
	QPopupMenu* pmenu;
	pmenu = new QPopupMenu( this );
    CHECK_PTR(pmenu);
	pmenu->insertItem( "&Import XML database...",  this, SLOT(importXML()));
	pmenu->insertItem( "&Export database as XML...",  this, SLOT(exportXML()));
	pmenu->insertSeparator();
    pmenu->insertItem( "Preferences...", this, SLOT(prefs()),Key_P+CTRL);
	pmenu->insertSeparator();
	pmenu->insertItem( "E&xit",  this, SLOT(quit()), CTRL+Key_Q );
    menu->insertItem( "&File", pmenu );

	pmenu = new QPopupMenu( this );
    CHECK_PTR(pmenu);
    pmenu->insertItem( "Queue and &Play", this, SLOT(queue()),Key_L+CTRL);
    pmenu->insertItem( "Queue and &Add", this, SLOT(enqueue()),Key_A+CTRL);
    pmenu->insertItem( "&Find and queue songs in playlist...", this, SLOT(search()),Key_F+CTRL);
    pmenu->insertItem( "Manage Playlists...", this, SLOT(playlists()));
    menu->insertItem( "&Playlists", pmenu);

	//this one needs to be modified afterwards
	viewMenu = new QPopupMenu( this );
    CHECK_PTR( viewMenu );
    viewMenu->insertItem( "later", this, SLOT(toggleShowMain()),Key_1+CTRL); //0
    viewMenu->insertItem( "later", this, SLOT(toggleShowQueue()),Key_2+CTRL);//1
    viewMenu->insertItem( "later", this, SLOT(toggleShowCurrent()),Key_3+CTRL);//2
    viewMenu->insertItem( "Clear Played Songs", this, SLOT(clearLists()));
    menu->insertItem( "&View", viewMenu);

	pmenu = new QPopupMenu( this );
    CHECK_PTR( pmenu);
    pmenu->insertItem( "&About",  this, SLOT(showAbout()));
    menu->insertItem( "&Help", pmenu);

	//additional cosmetics
	QPalette p = menu->palette();
	QColorGroup cgrp = p.normal();
	cgrp.setBrush(QColorGroup::Base,this->palette().brush(QPalette::Normal,QColorGroup::Background));
	menu->setPalette(p);

}

void LPWindowMain::toggleAlwaysOnTop() {
	if (testWFlags(WStyle_StaysOnTop) ) clearWFlags(WStyle_StaysOnTop ); else setWFlags( WStyle_StaysOnTop );
}

void LPWindowMain::show() {
	LPWindowMainBase::show();
    setFocus();
	checkMenus();
}

//prereq: complelety started lplayer
void LPWindowMain::notify(int /*i*/) {
	if (getApp()->quitting())  quit();
	//relaunch this notification as an event in the GUI thread
	QThread::postEvent(this,new LPGUIEvent(LPGUIEvent::LPNOTIFY,""));
}

bool LPWindowMain::event(QEvent* e) {
#ifdef _WS_WIN_
	if (e->type() == QEvent::Hide) { //this event is received when minimizing.. (thx to Nathan Brown for this one)
			if (getSettings()->getSetting(SettingHideOnMinimize)) this->hide();
		return true;
	}
#endif
	if (e->type() == QEvent::User ) {
		if (LPGUIEvent *lpe = (LPGUIEvent*)(e) ) {
			int type = lpe->getType();
			switch (type) {
			//todo stack operations on busy messages
			case LPGUIEvent::READY:
				statusbar->clear();
				_msgbusy = false;
				break;
			case LPGUIEvent::BUSY:
				
				if (!lpe->getValue()) { //if not modal, add 2 statusbar
                statusbar->message(QString::fromLocal8Bit(lpe->getMessage().c_str()),0);
				_msgbusy = true;
				}
				break;
			case LPGUIEvent::LPINFO:
				if (!_msgbusy) statusbar->message(QString::fromLocal8Bit(lpe->getMessage().c_str()),lpe->getValue());
				break;
			case LPGUIEvent::LPMESSAGE:
			    QMessageBox::information( this, "LongPlayer...", lpe->getMessage().c_str());
				break;
			case LPGUIEvent::LPERROR:
				statusbar->message(lpe->getMessage().c_str(),10000);
			    QMessageBox::critical( this, "LongPlayer...", lpe->getMessage().c_str());
				break;
			case LPGUIEvent::LPQUIT:
				quit();
				break;
			case LPGUIEvent::LPNOTIFY:
				logDebug("LPUI::song changed. updating gui.");
				update();
				break;
			}
			return true;
		}
    }
	return LPWindowMainBase::event(e);
}

//updates song info
void LPWindowMain::update() {
	if (!getApp()->SongCurrent().equivalent(_lastSong)) {
		_lastSong = getApp()->SongCurrent();
		logDebug("gui sees new song.");
		//add..
		if (!_lastSong.empty())_playedSongHandler->makeSongListViewItem(viewPlayedSongs,_lastSong);
		//..select 
		//we do this here because trimming might cause the selected song to disappear
		setSelectedSong(_lastSong);
		//..and trim
		bool trim = getSettings()->getSetting(SettingTrim);
		int trimVal = getSettings()->getSetting(SettingTrimVal);
		if (trim && (viewPlayedSongs->childCount() > trimVal)) {
			QListViewItem* litem = viewPlayedSongs->firstChild(); 
			for (int i=0;litem && (i < trimVal);i++) 
				litem = litem->nextSibling();
			while (litem) {
				QListViewItem* ditem = litem;
				litem = litem->nextSibling(); 
				if (ditem == viewPlayedSongs->currentItem()) viewPlayedSongs->setCurrentItem(viewPlayedSongs->firstChild());
				delete ditem;
			}
		}
	}
	else {
		setSelectedSong(getApp()->SongRetrieve(_selectedSong.getKey()));//update details
	}

	updateWidgets();
	updateTrayIcon();

	//refresh played songs list
	bool odd = false; Song s;
	PlayedSongItem* pitem = (PlayedSongItem*) viewPlayedSongs->firstChild();
	while (pitem) { 
		pitem->setOdd(odd); odd = !odd;
		QString key = pitem->text(6);
		if (!key.isEmpty()) { //Win Qt2 check
			s = getApp()->SongRetrieve(string(key.local8Bit()));
			logDebug(s.getFilename());
			if (!s.getFilename().empty()) _playedSongHandler->makeSongListViewItem(0,s,pitem);
		}
		pitem = (PlayedSongItem*) pitem->nextSibling();	
	}

	//show window if necessary
	if (_splash) {
		delete _splash; _splash = 0;
		if (!getSettings()->testSetting(SettingStartInTray)) this->show();
	}

	logDebug("LPUI::song changed. updating gui. done.");
}

void LPWindowMain::updateWidgets() {
	//refresh widgets
	chkQueue->setChecked(getApp()->getAutoQueue());
	genreQMatrix->setMessage("draw a rectangle\n to constrain");
	genreQMatrix->setConstraint(getSettings()->getSetting(QueueBuilder::ColorConstraintX1),getSettings()->getSetting(QueueBuilder::ColorConstraintY1),getSettings()->getSetting(QueueBuilder::ColorConstraintX2),getSettings()->getSetting(QueueBuilder::ColorConstraintY2));
	sliderQRating->setValue(-1 * getSettings()->getSetting(QueueBuilder::SettingMinimumRating));
	refreshPlaylists();
}

void LPWindowMain::updateTrayIcon() {
#ifdef _WS_WIN_
	Song sng = getApp()->SongCurrent();
	//refresh tray tooltip
	if (sng.getFilename().empty()) tray->setToolTip("no song playing");
	else
	tray->setToolTip(
		string(
			sng.getName() +
			" (" +
			absUtil::its(sng.getLike() + 5) +
			"/10" +
			" length: " +
			absUtil::shortTimeSpan(sng.length()) +
			", times: " +
			absUtil::its(sng.getTimes())
		).c_str()
	);

	//..and tray popupmenu
    QPopupMenu* tmenu = new QPopupMenu();
    (*tmenu).insertItem( "&Play Random Songs", this, SLOT(queue()) );

	QPopupMenu* playlistsmenu = new QPopupMenu();
    CHECK_PTR( playlistsmenu );
	vector<string> s = getApp()->getPlaylists();
	string currplaylist = getApp()->currentPlaylist();
	for (int i=0;i<s.size();i++) {
		playlistsmenu->insertItem( QString::fromLocal8Bit(s[i].c_str()) );
		if (currplaylist == s[i]) {
			playlistsmenu->setItemChecked(playlistsmenu->idAt(playlistsmenu->count()-1), true);
		}
	}
	connect(playlistsmenu , SIGNAL(activated(int)), this, SLOT(setPlaylist(int) ) );
    (*tmenu).insertItem("&Change Playlist", playlistsmenu);

	if (getApp()->getAutoQueue())
		(*tmenu).insertItem( "&Stop Queueing", this, SLOT(toggleQueue()) );
	else
		(*tmenu).insertItem( "&Start Queueing", this, SLOT(toggleQueue()) );
    (*tmenu).insertSeparator();
    (*tmenu).insertItem( "Rate &Up", this, SLOT(incRatingCurrentSong()) );
    (*tmenu).insertItem( "Rate &Down", this, SLOT(decRatingCurrentSong()) );
    (*tmenu).insertSeparator();
    (*tmenu).insertItem( "&Quit", this, SLOT(quit()) );

	QPopupMenu* prevmenu = tray->popup();
	tray->setPopup(tmenu);
	if (prevmenu) delete prevmenu;

	QPopupMenu* prevplaylistsmenu = _playlistsmenu;
	_playlistsmenu = playlistsmenu;
	if (prevplaylistsmenu) delete prevplaylistsmenu;
#endif
}

void LPWindowMain::setPlaylist(int i) {
#ifdef _WS_WIN_
	vector<string> s = getApp()->getPlaylists();
	string newplaylist = string(_playlistsmenu->text(i).local8Bit());
	getApp()->changePlaylist(newplaylist);
	updateWidgets();
	updateTrayIcon();
#endif
}

QString LPWindowMain::formatSongText(Song sng) {
	QString name, like, ago, times, length; int date;
    name = QString::fromLocal8Bit(sng.getName().c_str());
	if (sng.getFilename().empty()) return "no song playing";
	if (name.isEmpty()) name = sng.getFilename().c_str();
	if (sng.firstTime()) {
		times = "first time";
		ago = "first time";
	}
	else {
		date = sng.getOldDate();
		ago = absUtil::longTimeSpan(absUtil::getUtil()->date() - date).c_str();
		ago += " ago";
		times = absUtil::its(sng.getTimes()).c_str();
	}
	if (sng.getLike()) like = string(absUtil::its(sng.getLike() + 5) + "/10").c_str();
	else like = "neutral";
	if (sng.length() > 1) length = absUtil::shortTimeSpan(sng.length()).c_str();
					else length = "unknown";
    QFileInfo info(QString::fromLocal8Bit(sng.getFilename().c_str()));

	//take some dirs from the path
    QString filename1 = QString::fromLocal8Bit(sng.getFilename().c_str());
    char delimiter1;
    if (filename1.contains("/")) delimiter1 = '/'; else delimiter1 = '\\';
    QStringList dirs1 = QStringList::split( delimiter1,filename1,FALSE);
	QString dirClue = ""; QString dirClueSep = "";
	//Qt2 uses count instead of size
	uint i = 0;
	if (dirs1.count() > 4) i = dirs1.count() - 4;
	for (; i < dirs1.count() - 1; i++) {
			dirClue += dirClueSep + dirs1[i]; dirClueSep = " - "; 
	}
	dirClue += "<br>";

	return
		QString("<b><h3>") + QString::fromLocal8Bit (sng.getName().c_str()) + "</h3></b>" +
		dirClue + 
	//	QString(info.dirPath()) +
	//	QString("<br>rating: ") + absUtil::its(sng.getLike() + 5).c_str() + QString("/10") +
		QString(" size: ") + absUtil::its(sng.size() / 1024).c_str() + QString("kb") +
		QString(" length: ") + absUtil::shortTimeSpan(sng.length()).c_str()
		;
}

void LPWindowMain::setQConstraint(int x, int y, int x2, int y2) {
	getSettings()->setSetting(QueueBuilder::ColorConstraintX1,x);
	getSettings()->setSetting(QueueBuilder::ColorConstraintY1,y);
	getSettings()->setSetting(QueueBuilder::ColorConstraintX2,x2);
	getSettings()->setSetting(QueueBuilder::ColorConstraintY2,y2);
	getApp()->getLPlayer()->getQueueBuilder()->abort();
	getApp()->getLPlayer()->getQueueBuilder()->notifyNewSettings();
	logDebug(string("UI::constraint set to ") + absUtil::its(x));
}

void LPWindowMain::setSelectedSongGenre(int x, int y, int z) {
	Song s = getSelectedSong();
	logDebug(string("about to change genre of song ") + s.getKey());
	s.setColor(x,y,z);
	logDebug(string("UI::hue set to ") + absUtil::its(x));
	getApp()->SongStore(s);
}

void LPWindowMain::enqueue() {
	logDebug("UI::user pressed queue.");
	getApp()->queue(false);
}

void LPWindowMain::queue() {
	logDebug("UI::user pressed queue.");
	getApp()->queue();
}

void LPWindowMain::pplay() {
	getApp()->getMPlayer()->play();
}

void LPWindowMain::pstop() {
	getApp()->getMPlayer()->stop();
}

void LPWindowMain::pnext() {
	getApp()->getMPlayer()->next();
}

void LPWindowMain::pprevious() {
	getApp()->getMPlayer()->previous();
}

void LPWindowMain::clearLists() {
	viewPlayedSongs->clear();
	viewQueuedSongs->clear();
}

void LPWindowMain::prefchange() {
	QString s = boxPlaylist->currentText ();
	if (s) getApp()->changePlaylist(string(s.local8Bit()));
	updateTrayIcon();
}

void LPWindowMain::refreshPlaylists() {
	boxPlaylist->clear();
	vector<string> playlists = getApp()->getPlaylists();
	uint curr=0;
    QStringList list;
    	uint i;
	for (i=0;i<playlists.size();i++) {
        list << QString::fromLocal8Bit(playlists[i].c_str());
	}
    list.sort();
	for (i=0;i<playlists.size();i++) {
		if (list[i] == getApp()->currentPlaylist().c_str()) {
		curr = i;
		}
	}
	boxPlaylist->insertStringList(list);
	boxPlaylist->setCurrentItem (curr);
	QString s = boxPlaylist->currentText ();
	if (s) getApp()->changePlaylist(string(s.local8Bit()));
}

void LPWindowMain::checkMenus() {
	if (grpCurrent->isVisible()) viewMenu->changeItem(viewMenu->idAt(2), "Hide &Song Pane");
	else viewMenu->changeItem(viewMenu->idAt(2), "Show &Song Pane");
	if (grpPlayed->isVisible()) viewMenu->changeItem(viewMenu->idAt(1), "Hide Song &List");
	else viewMenu->changeItem(viewMenu->idAt(1), "Show Song &List");
	if (grpMain->isVisible()) viewMenu->changeItem(viewMenu->idAt(0), "Hide &Controls");
	else viewMenu->changeItem(viewMenu->idAt(0), "Show &Controls");
	viewMenu->setItemEnabled(viewMenu->idAt(0),!_stateMinimal);
	viewMenu->setItemEnabled(viewMenu->idAt(1),!_stateMinimal);
	viewMenu->setItemEnabled(viewMenu->idAt(2),!_stateMinimal);
}

void LPWindowMain::prefs() {
	LPFormPrefs dialog( getApp(),this, 0, TRUE,WStyle_DialogBorder  );
	dialog.exec();
#ifdef _WS_WIN_
	if (getSettings()->getSetting(SettingTray)) tray->show();
		else tray->hide();
#endif
	update();
}

void LPWindowMain::playlists() {
	LPFormPlaylists dialog(getApp(), this, 0, TRUE,WStyle_DialogBorder);
	dialog.exec();
	refreshPlaylists();
}

bool LPWindowMain::quitting() {
	return _quitting;
}

void LPWindowMain::quit() {
	if (quitting()) return;//safety precaution
	_quitting = true;
	getSettings()->setSetting(SettingTitleWidth,viewPlayedSongs->columnWidth(1));

	if (!_stateMinimal) saveLayout();
	logDebug("UI::exiting main window...");
	delete _splash;
	delete _mediaBar; delete _mainBar;
	getApp()->quit();
	delete this;
}

void LPWindowMain::changeQRating(int newlike) {
	newlike *= -1;
	getSettings()->setSetting(QueueBuilder::SettingMinimumRating,newlike);
	getApp()->getLPlayer()->getQueueBuilder()->abort();
	getApp()->getLPlayer()->getQueueBuilder()->notifyNewSettings();
	logDebug(string("UI::min queue rating set to ") + absUtil::its(newlike));
}

void LPWindowMain::changeRating(int /*newlike*/) {
	int newlike = sliderCurrentRating->value();
	newlike *= -1;
	Song s = getSelectedSong();
	logDebug(string("about to change rating of song ") + s.getKey());
	if (s.getLike() == (newlike -5)) return;
	s.setLike(newlike -5);
	getApp()->SongStore(s);
	logDebug(string("UI::rating set to ") + absUtil::its(newlike));
}

//updates song details pane
//this gets called 
//	- when an item is deleted by update
//	- when a user selects a song
//  - when an item is selected by update
// if item = 0 the currently playing song is selected
void LPWindowMain::selectSong(QListViewItem* item) {
	if (item) { 
		setSelectedSong(getApp()->SongRetrieve(item->text(6).latin1()));
		logDebug("UI::item from GUI selected:" + _selectedSong.getFilename());
	}
	else setSelectedSong(getApp()->SongCurrent()); 
}

void LPWindowMain::setSelectedSong(Song sng) {
	_selectedSong = sng;
	//refresh selected song details
	sliderCurrentRating->setValue(-1 * (sng.getLike() + 5));
	txtSong->setText(formatSongText(sng));

	if (sng.getFilename().empty()) sliderCurrentRating->setEnabled(false);
	else if (!sliderCurrentRating->isEnabled()) sliderCurrentRating->setEnabled(true);
	int x,y,z;
	sng.getColor(&x,&y,&z);
	genreMatrix->setEnabled(!sng.empty());
	genreMatrix->setGenre(x,y,z);
	if (sng.empty()) genreMatrix->setMessage("no song info");
	else genreMatrix->setMessage("click to set genre");
}

Song LPWindowMain::getSelectedSong() { return _selectedSong; }

void LPWindowMain::playNow(QListViewItem* item) {
	Song s = getApp()->SongRetrieve(item->text(6).latin1());
	if (s.getFilename().empty()) return;
	vector<string> files; files.push_back(s.getFilename());
	getApp()->play(files,true);
}

void LPWindowMain::importXML() {
	QMessageBox::information( this, "Importing Database from XML",
                            "This will allow you to import songs to the LongPlayer database from an XML file.\nSong statistics will be updated to their newest version.");
	QString lastdir = QString::fromLocal8Bit(getSettings()->getSetting("fileactions","lastdir").c_str());
	QString s = QFileDialog::getOpenFileName( lastdir, "XML ( *.xml );;All files ( * )", this, 0 , "Choose filename for XML import");
	if ( s.isEmpty() )
		return;
	getSettings()->setSetting("fileactions","lastdir",string(QFileInfo(s).dirPath().local8Bit()));
	getApp()->DatabaseImportXML(string(s.local8Bit()));
}

void LPWindowMain::exportXML() {
	QString lastdir = QString::fromLocal8Bit(getSettings()->getSetting("fileactions","lastdir").c_str());
	QString s = QFileDialog::getSaveFileName( lastdir, "XML ( *.xml );;All files ( * )", this, "save to xml", "Choose filename for XML export");
	if ( s.isEmpty() )
		return;
	getSettings()->setSetting("fileactions","lastdir",string(QFileInfo(s).dirPath().local8Bit()));
	if(s.contains('.',true)<1) {
		s = s + ".xml";
	}
	getApp()->DatabaseExportXML(string(s.local8Bit()));
}

void LPWindowMain::toggleAnalyze() {
//	getApp()->setAutoAnalyze(chkAnalyze->isChecked());
}

void LPWindowMain::toggleQueue() {
	getApp()->setAutoQueue(!getApp()->getAutoQueue()); 
	updateTrayIcon();
	updateWidgets();
}

void LPWindowMain::setLayout() {
	LPSettings* s = getSettings();
	QString imgPrefix = QDir(
		QString::fromLocal8Bit(LPSettings::getResourceDir().c_str())
		).absPath();
	imgPrefix += "/images/";
	if (s->getSetting(SettingMinimal)) {
		if (_minimalButton) _minimalButton->setIconSet(QPixmap(imgPrefix + "normal.png"));
		grpCurrent->hide();
		grpMain->hide();
		grpPlayed->hide();
		mainWidget->hide();
		int w = _mainBar->width();
		adjustSize();
		resize(w,96);
	}
	else {
		mainWidget->show();
		if (_minimalButton) _minimalButton->setIconSet(QPixmap(imgPrefix + "minimal.png"));
		if (s->testSetting(SettingShowMain) && !s->getSetting(SettingShowMain)) grpMain->hide(); else grpMain->show();
		if (s->testSetting(SettingShowCurrent) && !s->getSetting(SettingShowCurrent)) grpCurrent->hide();else grpCurrent->show();
		if (s->testSetting(SettingShowPlayed) && !s->getSetting(SettingShowPlayed)) grpPlayed->hide(); else grpPlayed->show();
		adjustSize();
		if (s->testSetting(SettingWidth)) resize(s->getSetting(SettingWidth), s->getSetting(SettingHeight));
	}
	checkMenus();

}

void LPWindowMain::saveVisibility() {
	getSettings()->setSetting(SettingShowCurrent,grpCurrent->isVisible());
	getSettings()->setSetting(SettingShowPlayed,grpPlayed->isVisible());
	getSettings()->setSetting(SettingShowMain,grpMain->isVisible());

	getSettings()->setSetting(SettingMediabar,_mediaBar->isVisible());
	getSettings()->setSetting(SettingMainbar,_mainBar->isVisible());
}

void LPWindowMain::saveLayout() {
	logDebug("UI::Saving layout...");
	getSettings()->setSetting(SettingWidth,size().width());
	getSettings()->setSetting(SettingHeight,size().height());
	getSettings()->setSetting(SettingX,pos().x());
	getSettings()->setSetting(SettingY,pos().y());
}

void LPWindowMain::toggleMinimal() {
	_stateMinimal = !_stateMinimal;
	getSettings()->setSetting(SettingMinimal,_stateMinimal);
	if (_stateMinimal) {
		saveLayout();
	}
	setLayout();
}

void LPWindowMain::toggleShowCurrent() {
  	if (grpCurrent->isVisible()) {
		grpCurrent->hide();
		if (!grpPlayed->isVisible()) adjustSize();
	}
	else grpCurrent->show();
	getSettings()->setSetting(SettingShowCurrent,grpCurrent->isVisible());
	checkMenus();
	if (!grpPlayed->isVisible()) adjustSize();
}

void LPWindowMain::toggleShowMain() {
  	if (grpMain->isVisible()) { 
		grpMain->hide();
		if (!grpPlayed->isVisible()) adjustSize();
	}
	else grpMain->show();
	getSettings()->setSetting(SettingShowMain,grpMain->isVisible());
	checkMenus();
}

void LPWindowMain::toggleShowQueue() {
  	if (grpPlayed->isVisible()) grpPlayed->hide();
	else grpPlayed->show();
		getSettings()->setSetting(SettingShowPlayed,grpPlayed->isVisible());
	checkMenus();
	if (!grpPlayed->isVisible()) adjustSize();
}

void LPWindowMain::toggleShow() {
	if (this->isVisible() && !this->isMinimized()) this->hide();
	else {
		this->show();
		if (this->isMinimized()) this->showNormal();
		this->setActiveWindow();
	}
}

void LPWindowMain::search() {
	LPFormSearch dialog(getApp(),this, 0, TRUE,WStyle_DialogBorder | WStyle_MinMax | WStyle_SysMenu  );
	dialog.exec();
}

void LPWindowMain::showAbout() { LPFormAbout dialog(getApp(), this, 0, TRUE,WStyle_DialogBorder); dialog.exec(); }

void LPWindowMain::incRatingCurrentSong() {
	Song s = getApp()->SongCurrent();
	s.setLike(s.getLike()+1);
	getApp()->SongStore(s);
}

void LPWindowMain::decRatingCurrentSong() {
	Song s = getApp()->SongCurrent();
	s.setLike(s.getLike()-1);
	getApp()->SongStore(s);
}

void PlayedSongHandler::makeSongListViewItem(QListView* list, Song sng,QListViewItem* vitem) {
	if (!vitem) { PlayedSongItem* sitem = new PlayedSongItem(list,sng); list->ensureItemVisible(sitem); }
	else ((PlayedSongItem*)vitem)->setSong(sng);
}

PlayedSongItem::PlayedSongItem(QListView* list, Song sng) : QListViewItem(list), _odd(false) {
    QListViewItem::setText(0,QTime::currentTime().toString());//0
    QListViewItem::setText(7,absUtil::its(absUtil::getUtil()->date()).c_str());//7
    setSong(sng);
}

QString PlayedSongItem::getSongKey() { return text(6); }

void PlayedSongItem::setSong(Song sng) {
    QString name, like, ago, times, length; int date;
    name = QString::fromLocal8Bit(sng.getName().c_str());

    if (name.isEmpty()) name = "unknown";
    if (sng.firstTime()) {
        ago = "first time"; times = "first time";
    }
    else {
       date = sng.getOldDate();
	   if (!date) {
			date = sng.getDate();
			logWarning("LPUI::old date did not exist, new song?");
	   }
       ago = string(absUtil::longTimeSpan(absUtil::getUtil()->date() - date) + " ago").c_str();
	   times = string(string(" ") + absUtil::its(sng.getTimes())).c_str();
    }
    if (sng.getLike()) like = string(" " + absUtil::its(sng.getLike() + 5) + "/10").c_str();
    else like = "neutral";
    if (sng.length() > 0) length = absUtil::shortTimeSpan(sng.length()).c_str();
        else length = "unknown";

    int i = 1;
    QListViewItem::setText(i++,name);//1
    QListViewItem::setText(i++,like);//2
    QListViewItem::setText(i++,ago);//3
    QListViewItem::setText(i++,times);//4
    QListViewItem::setText(i++,length);//5
    QListViewItem::setText(i++,sng.getKey().c_str());//6
    playedcolid = 6;
	_filename = sng.getFilename();
}

QString PlayedSongItem::key(int column, bool ascending) const {
        if (column == 0) {
            return text(7);
        }
        else return QListViewItem::key(column,ascending);
}

string PlayedSongItem::getFilename() { return _filename; }
void PlayedSongItem::activate() { }
void PlayedSongItem::setOdd(bool b) { _odd = b; }

void PlayedSongItem::paintCell( QPainter *p, const QColorGroup &cg,
                                 int column, int width, int alignment )
{
    QColorGroup newcg( cg );
    QColor c = newcg.text();
	QColor d;
	d.setNamedColor("#EDF3FE");

    if (_odd) newcg.setColor( QColorGroup::Base, d );

    QListViewItem::paintCell( p, newcg, column, width, alignment );

    newcg.setColor( QColorGroup::Text, c );
}

PlayedSongTip::PlayedSongTip(QWidget* parent) : QToolTip(parent) { }

void PlayedSongTip::maybeTip(const QPoint &p) {
	QListView* view = ((QListView*)(parentWidget()->parentWidget()));
	if (!view->itemAt(p)) return;
	logDebug(((PlayedSongItem*)view->itemAt(p))->getFilename());
	QRect rec = 	view->itemRect ( view->itemAt(p));
    QFileInfo file = QFileInfo(QString::fromLocal8Bit(((PlayedSongItem*)view->itemAt(p))->getFilename().c_str()));

	tip( rec, QString("Filename:\n") + file.fileName() + "\nLocation:\n" + file.dirPath());
}

void PlayedSongHandler::ListSongRate(int i) {
	QString text = ratesong->text(i);
	if (text[1] == '0') s.setLike(5);
	else
		s.setLike(text[0].digitValue()-5);
	makeSongListViewItem(0,s,item);
	getApp()->SongStore(s);

}

void PlayedSongHandler::setDirGenre() {
	int x,y,z;
	s.getColor(&x,&y,&z);
    string dir = string(QFileInfo(QString::fromLocal8Bit(s.getFilename().c_str())).dirPath().local8Bit());
	logBusy("Setting genre...",0);
	qApp->processEvents();
	getApp()->applyGenreToDir(dir, x,y,z);
	logReady("Setting genre...");
}

void PlayedSongHandler::ListDirRate(int i) {
	QString text = ratedir->text(i);
    string dir = string(QFileInfo(QString::fromLocal8Bit(s.getFilename().c_str())).dirPath().local8Bit());
	logBusy("Rating dir...",0);
	qApp->processEvents();
	int like;
	if (text[1] == '0') like = 5; //max score (10/10)
	else
	like = text[0].digitValue()-5;
	getApp()->applyRatingToDir(dir,like);
	logReady("Rating dir...");
}

void PlayedSongHandler::ListSongRefresh() { makeSongListViewItem(0,s,item); }

void PlayedSongHandler::ListSongIncRating() {
	s.setLike(s.getLike()+1);
	makeSongListViewItem(0,s,item);
	getApp()->SongStore(s);
}

void PlayedSongHandler::ListSongDecRating() {
	s.setLike(s.getLike()-1);
	makeSongListViewItem(0,s,item);
	getApp()->SongStore(s);
}

void PlayedSongHandler::ListSongReset() {
	s.resetListen();
	makeSongListViewItem(0,s,item);
	getApp()->SongStore(s);
}

void PlayedSongHandler::ListSongCopyDescription() {
    QApplication::clipboard()->setText( QString::fromLocal8Bit(string(s.getName() + " (" + absUtil::its(s.getLike() + 5) + "/10)") .c_str()));
}

void PlayedSongHandler::ListSongCopyPath() {
    QApplication::clipboard()->setText( QString::fromLocal8Bit(s.getFilename().c_str()));
}

void PlayedSongHandler::ListSongReplay() {
	vector<string> files; files.push_back(s.getFilename());
	getApp()->play(files,true);
}

void PlayedSongHandler::ListPlaylistPlay() {
	//check for associated playlist
	QString dirName = QFileInfo(QString::fromLocal8Bit(s.getFilename().c_str())).dirPath();
	QString assocd  = "";
    QDir d(dirName);
	if (dirName.isEmpty() || !QDir(dirName).exists() ) return;
    d.setFilter( QDir::Files);
	d.setNameFilter("*.m3u"); //TODO proper extension(s)
    if (!d.entryList().isEmpty()) {
        assocd = d.path() + "/" + d[0];
	}
	vector<string> files; files.push_back(string(assocd.local8Bit()));
	getApp()->play(files,true);
}

void PlayedSongHandler::ListDirPlay() {
	vector<string> files; files.push_back(string(QFileInfo(QString::fromLocal8Bit(s.getFilename().c_str())).dirPath().local8Bit()));
	getApp()->play(files,true);
}

void PlayedSongHandler::ListSongRequeue() {
	vector<string> files; files.push_back(s.getFilename());
    getApp()->play(files, false);
}

void PlayedSongHandler::ListSongRemoveFromDisk() {
    QMessageBox mb( "LongPlayer",
                    "This will remove the file from disk.\n"
                    "Are you sure?",
                    QMessageBox::Information,
                    QMessageBox::Yes,
                    QMessageBox::No | QMessageBox::Default | QMessageBox::Escape,
					QMessageBox::NoButton
                    );
	mb.setButtonText( QMessageBox::Yes, "Remove");
	mb.setButtonText( QMessageBox::No, "Cancel");
    switch( mb.exec() ) {
        case QMessageBox::Yes:
			if (absUtil::getUtil()->removeFile(s.getFilename()),true) {
				item->setText(2,"removed");
				item->setText(3,"N/A");
				item->setText(4,"N/A");
				item->setText(5,"N/A");
				item->setText(6,"N/A");
			}
			else {
				logError("Failed to remove the file. Check for processes keeping a lock on it (e.g. your player).");
			}
            break;
        case QMessageBox::No:
            break;
    }
}

void PlayedSongHandler::viewPopup(QListViewItem* nitem, const QPoint& point) {
	if (!nitem) return;
	setItem(nitem);

	Song nsong = getApp()->SongRetrieve(string(((PlayedSongItem*)item)->getSongKey().local8Bit()));
	if (nsong.getFilename().empty()) return;
	setSong(nsong);

	//check for associated playlist
	QString dirName = QFileInfo(QString::fromLocal8Bit(s.getFilename().c_str())).dirPath();
	QString assocd  = "";
    QDir d(dirName);
	if (dirName.isEmpty() ) { logDebug("UI::dir does not exist1"); return;}
	if (!d.exists() ) { logDebug(string("UI::dir ") + string(dirName.local8Bit())  + " does not exist2"); return;}
    d.setFilter( QDir::Files);
	d.setNameFilter("*.m3u"); //TODO proper extension(s)
    if (!d.entryList().isEmpty()) { assocd = d.path() + "/" + d[0]; }

	QPopupMenu *file = new QPopupMenu( widget );
    CHECK_PTR( file );
    file->insertItem( "Refresh this line",  this, SLOT(ListSongRefresh()));
	file->insertSeparator();
	//is not deleted... todo
	ratesong = new QPopupMenu( widget );
    CHECK_PTR( ratesong );
	for (int i=0;i<=10;i++) {
		ratesong->insertItem( string(absUtil::its(i)+ "/10").c_str());
	}
	connect(ratesong, SIGNAL(activated(int)), this, SLOT(ListSongRate(int)) );
	ratedir = new QPopupMenu( widget );
    CHECK_PTR( ratedir );
	for (int j=0;j<=10;j++) ratedir->insertItem( string(absUtil::its(j)+ "/10").c_str() );
	connect(ratedir, SIGNAL(activated(int)), this, SLOT(ListDirRate(int)) );

    file->insertItem("Rate", ratesong);
    file->insertItem("Rate Directory", ratedir);
    file->insertItem("Apply &Genre to Directory",this, SLOT(setDirGenre()));
	//TODO rate playlist

    file->insertItem( "&Reset date",  this, SLOT(ListSongReset()));
	file->insertSeparator();
    file->insertItem( "&Play now",  this, SLOT(ListSongReplay()));
    file->insertItem( "Play directory now",  this, SLOT(ListDirPlay()));
    if (!assocd.isEmpty()) file->insertItem( "Play &M3U now",  this, SLOT(ListPlaylistPlay()));
    file->insertItem( "Re&queue",  this, SLOT(ListSongRequeue()));
	file->insertSeparator();
    file->insertItem( "Copy &info to clipboard",  this, SLOT(ListSongCopyDescription()));
    file->insertItem( "Copy path to clipboard",  this, SLOT(ListSongCopyPath()));
    file->insertItem( "R&emove file from disk",  this, SLOT(ListSongRemoveFromDisk()));

	file->popup(point);
}

void PlayedSongHandler::setSong(Song ns) { s = ns; }
void PlayedSongHandler::setItem(QListViewItem* nitem) { item = nitem; }
LPApp* PlayedSongHandler::getApp() { return _app; }
void PlayedSongHandler::setApp(LPApp* app) { _app = app; }
PlayedSongHandler::PlayedSongHandler(QWidget* qwidget) { widget = qwidget; }
PlayedSongHandler::~PlayedSongHandler() { }

LPToolBar::LPToolBar (LPSettings* s,string setting, QMainWindow* m, const char* name) : QToolBar(name,m,m), _settings(s), _setting(setting) { }

void LPToolBar::showEvent(QShowEvent* /*event*/) { if (!isHidden()) { _settings->setISetting("windows",_setting, true);} }

void LPToolBar::hideEvent(QHideEvent* /*event*/) { if (_settings) _settings->setISetting("windows",_setting, !isHidden());	}

void LPToolBar::polish() {
	QToolBar::polish();
	if (_settings->testSetting("windows",_setting) && !_settings->getISetting("windows",_setting)) { this->hide(); }

}

