/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef LPMWINBASE_H
#define LPMWINBASE_H

#include <qvariant.h>
#include <qmainwindow.h>
#include <qsplitter.h>

class QVBoxLayout;
class QHBoxLayout;
class QHBox;
class QGridLayout;
class QCheckBox;
class QComboBox;
class QDial;
class QSlider;
class QGroupBox;
class QLabel;
class QListBox;
class QListView;
class QListViewItem;
class QPushButton;
class QTextView;
class GenreWidget;
class GenreConstraintWidget;

class LPWindowMainBase : public QMainWindow
{
    Q_OBJECT

public:
    LPWindowMainBase( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	virtual ~LPWindowMainBase();

    QGroupBox* grpPlayed, *grpQueued, *grpMain, *grpCurrent;
	QHBox* boxPlayed, *boxMain, *boxCurrent;
    QListView* viewPlayedSongs;

    QLabel* TextLabel1_3;
    QListBox* boxPlaylist;
    QPushButton* btnStart;
    QPushButton* btnQueue;
    QCheckBox* chkAnalyze;
    QCheckBox* chkQueue;

    QListView* viewQueuedSongs;
    QTextView* txtSong;
    QLabel* TextLabel1;
    QLabel* TextLabel2;
    QSlider* sliderCurrentRating;
    QSlider* sliderQRating;
    QLabel* TextLabel1_2;
	QHBox* mainWidget;
public slots:
	virtual void accept();
    virtual void changeRating(int);
    virtual void changeQRating(int);
    virtual void playNow(QListViewItem*);
    virtual void selectSong(QListViewItem*);
    virtual void prefchange();

	virtual void pplay();
	virtual void pstop();
	virtual void pnext();
	virtual void pprevious();

    virtual void prefs();
    virtual void queue();
    virtual void search();
    virtual void toggleAnalyze();
    virtual void toggleQueue();
    virtual void toggleShowCurrent();
    virtual void toggleShowQueue();

protected:
    QHBoxLayout* grpPlayedLayout;
    QHBoxLayout* grpMainLayout;
    QHBoxLayout* grpQueuedLayout;
    QHBoxLayout* grpCurrentLayout;
	GenreWidget* genreMatrix;
	GenreConstraintWidget* genreQMatrix;
};

#endif
