#include "m3uplaylist.h"
#include "absutil.h"
#include <qdir.h>
#include <qstringlist.h>
#include <qregexp.h>
#include <qtextstream.h>

const int M3UPlaylist::TYPE = 11;

int M3UPlaylist::getType() { return TYPE; }
M3UPlaylist::M3UPlaylist() : Playlist("noname") {}
M3UPlaylist::M3UPlaylist(string name) : Playlist(name) {}

bool M3UPlaylist::equals(Playlist* list) {
	logDebug("m3uplaylist::equals");
	if (list->getType() != TYPE) return false;
	if (((M3UPlaylist*)list)->getM3U() != getM3U()) return false;
	return Playlist::equals(list);
}

void M3UPlaylist::buildStep(vector<string>* /*temp*/) { }
void M3UPlaylist::buildCleanup(vector<string>* /*temp*/) { }

void M3UPlaylist::buildInit(vector<string>* temp) {
    logDebug(string("M3UPlaylist::building list of files..."));
	_buildMutex->lock();
	_built = true;
	_buildMutex->unlock();

	string filename = getM3U();
    QFile f(QString::fromLocal8Bit(filename.c_str()));
    if (filename.empty() || !absUtil::getUtil()->existsFile(filename) || !f.open(IO_ReadOnly)) {
        logWarning(string("LPSettings::reading m3u ") + filename + " failed.");
		return;//thrown CannotBuildPlaylistException
    }
    QTextStream t( &f );
    string st;

	QString line;
	bool found;
	while (!t.atEnd()) {
		found = false;
		line = t.readLine();
		if ((line.left(1) == "#") || line.isEmpty()) {}
		else {	
           QFileInfo info(line);
           QFileInfo m3u(QString::fromLocal8Bit(filename.c_str()));
            if (info.exists()) found = true;
			else
            {
                //1. add directory and try again
                QString slash = ((line.left(1) == "/") || (line.left(1) == "\\")) ? "" : "/";
                info = QFileInfo(m3u.dirPath() + slash + line);
                if (info.exists()) {
                    line = info.filePath(); found = true;
                }
                else {
                    //2. (DOS): add drive and try again 
                    QString path  = m3u.dirPath();
                    info = QFileInfo(
                            path.left(2) +
                            slash +
                        line);
                    if (info.exists()) {
                        line = info.filePath(); found = true;
                    }
                    else {
                        logWarning(string("LPIterator::m3u points to non existing file ") + string(line.local8Bit()));
                    }
                }
            }
			if (found) temp->push_back(string(line.local8Bit()));
			//if (found) logDebug(string("found ")  + string(line.local8Bit()));
		}
	}
	_built = true;
	f.close();
}

string M3UPlaylist::getM3U() { return _m3u; }
void M3UPlaylist::setM3U(string filename) { _m3u = filename; }

bool M3UPlaylist::isM3U(string filename) {
    if (filename.empty()) return false;    
	bool result = false;    
	if (QString(filename.c_str()).right(3) == "m3u") result = true;    
	if (QString(filename.c_str()).right(3) == "pls") result = true;
	return result;
}
