/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2002 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef _WS_WIN_
#ifndef H_MPG123
#define H_MPG123
//#include <qvariant.h>

#include "lpglobal.h"
#include "absplayer.h"

class MPG123 : public absPlayer {
public:
	virtual void play(vector<string> filename);
	virtual void setVolume(int vol);
	virtual int getVolume();
	virtual void play();
	virtual void next();
	virtual void previous();
	virtual void stop();
	virtual void queue(vector<string> filename);
	virtual int getPlaylistPosition() const;
	virtual int getPlaylistLength() const;
	virtual bool isPlaying() const;
	virtual bool isRunning() const;

	virtual bool inPlaylist(string filename) const;
	virtual void cleanPlayed(int newsize);
	virtual void cleanQueued();
	virtual string getPath() const;
	virtual void test();
	virtual int getSongPosition() const;
private:
	virtual string getRSongName() const;
	virtual int getRSongLength() const;
	virtual string getRFileName() const;
	string rsongname;
	int rsonglength;
	string rfilename;
	bool isplaying;
	 
};


#endif
#endif
