/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_PLAYLIST
#define H_PLAYLIST

#include "lpglobal.h"
#include <qthread.h>
#include "lplistener.h"

#include <vector>
using namespace std;
class CompositePlaylist;
class Playlist;
/** abstract class representing a description of a collection of songs 
 *  using the collection description, a concrete list of songs can be built 
 */
class Playlist {
	friend class CompositePlaylist;

public:
    /** creates a new playlist 
	 * @param
	 *     string name: name of the playlist 
	 */
    Playlist(string name);
	virtual ~Playlist();
	
    /** returns name */
    string getName() const;
    /** sets name */
    void setName(string);

	/** songs returned by getList will end with one of these strings
	 *  if filter is empty, this has no effect
	 */
    void setFilenamesEndWith(vector<string> filter);
    vector<string> getFilenamesEndWith() const;
	/** songs returned by getList will contain one of these strings 
	 * if filter is empty, this has no effect
	 */
    void setFilenamesContain(vector<string> filter);
    vector<string> getFilenamesContain() const;
	/** songs returned by getList will not contain any of these strings
	 * if filter is empty, this has no effect
	 */
	void setFilenamesDoNotEndWith(vector<string> filter);
	vector<string> getFilenamesDoNotEndWith() const;

	/** synchronous function that builds a list of files this playlist represents and filters names
	 */
	void startBuilding();
	virtual void stopBuilding();
	bool getBuilt();
	
	/** returns a pointer to a list containing all the songs of this collection
	 * note: the filelist will be destroyed along with the playlist
	 * returns 0 if the list is not yet built
	 * returns an empty vector if no files match
	 * */
	vector<string>* filenames();

	virtual int getType()=0;
protected:
	virtual bool equals(Playlist*);
	bool validFilename(string filename);
	bool _abort;

    vector<string> _filenamesEndWith;
	vector<string> _filenamesDoNotEndWith;
	vector<string> _filenamesContain;
	
	//abstract methods
	virtual void buildInit(vector<string>*)=0;
	virtual void buildStep(vector<string>*)=0;
	virtual void buildCleanup(vector<string>*)=0;

	vector<string>* _filenames;
	bool _built;
	QMutex* _buildMutex;
	/** sets the playlist to be  used for filtering e.g. whose validFilename will be used */
	void setFilter(Playlist* filter);
	Playlist* getFilter();
private:
	string _name;
	Playlist* _filter;
};

#endif
