/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_LPQUEUEBUILDER
#define H_LPQUEUEBUILDER

#include <vector>
#include "lpglobal.h"
#include "lpsettings.h"

#include <qthread.h>

class LPDatabase;
class LPSettings;
class Playlist;
class absPlayer;
class LPSongFilter;

class QueueBuilder  {
public:
	static IntSetting ColorConstraintX1;
	static IntSetting ColorConstraintX2;
	static IntSetting ColorConstraintY1;
	static IntSetting ColorConstraintY2;
	static IntSetting SettingMinimumRating;
	static FloatSetting SettingAverageInterval;
	static FloatSetting SettingAverageRating;
	static FloatSetting SettingIntervalWeight;
	static FloatSetting SettingRatingWeight;
	static FloatSetting SettingLengthWeight;
	static IntSetting SettingDJMode;
	static IntSetting SettingDJEvery;
	static StringSetting SettingDJSong;

	QueueBuilder(LPSettings* settings, LPDatabase* database, absPlayer* player);
	virtual ~QueueBuilder();
	/**
	 * returns a number of (random) songs that can be queued
	 * pre: playlist.isBuilt()
	 */
	vector<string> getQueue(Playlist* playlist, int);
	void abort();

	/** called when the queue settings have changed */
	void notifyNewSettings();

	void test();
private:
	bool _stop;
	QMutex mutexFilter;
	
	/** adds to history, and queues dj announcement when necessary */
	void addToList(vector<string>* list, string filename);
	
	void buildFilter();
	
	LPSongFilter* getFilter();
	
	LPDatabase* getDatabase() const;
	LPSettings* getSettings() const;
	absPlayer* getPlayer() const;

	LPSongFilter* _filter;
	LPSettings* _settings;
	LPDatabase* _database;
	absPlayer* _player;

	vector<string> _history;
	int _historyPointer;

	int _djval;
};

#endif
