#include "synchronizeddbaccess.h"
#include "absutil.h"
#include "lpglobal.h"

#include <qstring.h>
#include <qdir.h>
#include <qdom.h>
#include <qtextstream.h>
#include <qprogressdialog.h>

#include <string>
#include <iostream>

SynchronizedDBAccess::SynchronizedDBAccess(LPDatabaseReader* reader) { _reader = reader; }
SynchronizedDBAccess::~SynchronizedDBAccess() { delete _reader; }

void SynchronizedDBAccess::flush() {
	dbAccess.lock();
	_reader->flush();
	dbAccess.unlock();
}

//AND rebuilds filepointers!!! AND makes filename this database
void SynchronizedDBAccess::compact() {
	dbAccess.lock();
	_reader->compact();
	dbAccess.unlock();
}

void SynchronizedDBAccess::store(Song song ) {
	logDebug("locking..");
	dbAccess.lock();
	_reader->store(song);
	dbAccess.unlock();
}

void SynchronizedDBAccess::remove(Song song) {
	dbAccess.lock();
	_reader->remove(song);
	dbAccess.unlock();
}

int SynchronizedDBAccess::getSize() {
	dbAccess.lock();
	int res = _reader->getSize();
	dbAccess.unlock();
	return res;
}

bool SynchronizedDBAccess::inDatabase(string key) {
	dbAccess.lock();
	bool b = _reader->inDatabase(key);
	dbAccess.unlock();
	return b;
}

//returns Song() if not in database
Song SynchronizedDBAccess::retrieve(Song key) {
	dbAccess.lock();
	Song s = _reader->retrieve(key);
	dbAccess.unlock();
	return s;
}

Song SynchronizedDBAccess::retrieve(string key) {
	dbAccess.lock();
	Song s = _reader->retrieve(key);
	dbAccess.unlock();
	return s;
}

SynchronizedDBAccess::SynchronizedIterator::SynchronizedIterator(SynchronizedDBAccess* database, LPDatabaseIterator* iterator) {
	_db = database;
	_iterator = iterator;
}

void SynchronizedDBAccess::SynchronizedIterator::reset() {
	_db->dbAccess.lock();
		_iterator->reset();
	_db->dbAccess.unlock();
}	

Song SynchronizedDBAccess::SynchronizedIterator::next() {
	_db->dbAccess.lock();
		Song s = _iterator->next();
	_db->dbAccess.unlock();
	return s;
}	

bool SynchronizedDBAccess::SynchronizedIterator::atEnd() {
	_db->dbAccess.lock();
		bool b = _iterator->atEnd();
	_db->dbAccess.unlock();
	return b;
}	

LPDatabaseIterator* SynchronizedDBAccess::iterator() {
    return new SynchronizedDBAccess::SynchronizedIterator(this,_reader->iterator());
}
