#include "tester.h"

#include "lpglobal.h"
#include "lpsettings.h"
#include "playlistreader.h"
#include "compositeplaylist.h"
#include "absutil.h"
#include "lpdatabase.h"
#include "lpdatabasereader.h"
#include "lpdatabaseiterator.h"

#include <qdatetime.h>

Tester::Tester(LPSettings* settings) : _settings(settings) { }

LPSettings* Tester::getSettings() { return _settings; }

void Tester::testAll() {
	testTimings();	
}

void Tester::testTimings() {
	QTime t;
	logInfo("Creating dbase.");
	t.start();
	LPDatabase db(getSettings());
	logInfo(absUtil::milliTimeSpan(t.elapsed()));

	LPDatabaseIterator* it = db.getReader()->iterator();

	logInfo("1000x reset.");
	t.start();
	for (int r=0;r<1000;r++) it->reset();
	logInfo(absUtil::milliTimeSpan(t.elapsed()));

	logInfo("Iterating over dbase.");
	t.start();
	while (!it->atEnd()) it->next();
	logInfo(absUtil::milliTimeSpan(t.elapsed()));



	logInfo("Building default playlist.");
	PlaylistReader pl(getSettings());
	CompositePlaylist* playlist = pl.getPlaylist(getSettings()->getSetting("lplayer","playlist") );
	t.start();
	playlist->startBuilding();
	logInfo(absUtil::milliTimeSpan(t.elapsed()));

	vector<string>* files = playlist->filenames();
	if (files)  {
		logInfo("Calculating CRC's.");
		t.start();
		for (uint i=0; i < files->size(); i++) {
			absUtil::getUtil()->getFileID( (*files)[i] );
		}
		logInfo(absUtil::milliTimeSpan(t.elapsed()));
		logInfo("Reading Db entries.");
		t.start();
		for (uint j=0; j < files->size(); j++) {
			db.retrieve(absUtil::getUtil()->getFileID( (*files)[j] ));
		}
		logInfo(absUtil::milliTimeSpan(t.elapsed()));
	}
	logDebug("Done.");
}

