#ifdef _WINDOWS
#include "winamp.h"
#include <fstream>
#include <qtextstream.h>
#include <qfileinfo.h>
#include <string>

using namespace std;

// $Id: winamp.cpp,v 1.9 2003/10/07 20:42:10 panixx Exp $
// mircamp.cpp : Defines the entry point for the DLL application.
//
//#include "absutil.h"
const char * messages[] = {
	"IPC_GETVERSION",			"IPC_GETTITLE",				"IPC_DELETE",				"IPC_STARTPLAY",
	"IPC_ISPLAYING",			"IPC_GETOUTPUTTIME",		"IPC_JUMPTOTIME",			"IPC_WRITEPLAYLIST",
	"IPC_SETPLAYLISTPOS",		"IPC_SETVOLUME",			"IPC_SETPANNING",			"IPC_GETLISTLENGTH",
	"IPC_GETLISTPOS",			"IPC_GETINFO",				"IPC_GETEQDATA",			"IPC_SETEQDATA",
	"IPC_ADDBOOKMARK",			"IPC_RESTARTWINAMP",		"IPC_PLAYFILE",				"IPC_CHDIR",
	"WINAMP_OPTIONS_EQ",		"WINAMP_OPTIONS_PLEDIT",	"WINAMP_VOLUMEUP",			"WINAMP_VOLUMEDOWN",
	"WINAMP_FFWD5S",			"WINAMP_REW5S",				"WINAMP_BUTTON1",			"WINAMP_BUTTON2",
	"WINAMP_BUTTON3",			"WINAMP_BUTTON4",			"WINAMP_BUTTON5",			"WINAMP_BUTTON1_SHIFT",
	"WINAMP_BUTTON2_SHIFT",		"WINAMP_BUTTON3_SHIFT",		"WINAMP_BUTTON4_SHIFT",		"WINAMP_BUTTON5_SHIFT",

	"WINAMP_BUTTON1_CTRL",		"WINAMP_BUTTON2_CTRL",		"WINAMP_BUTTON3_CTRL",		"WINAMP_BUTTON4_CTRL",

	"WINAMP_BUTTON5_CTRL",		"WINAMP_FILE_PLAY",			"WINAMP_OPTIONS_PREFS",		"WINAMP_OPTIONS_AOT",

	"WINAMP_HELP_ABOUT",		"IPC_GETPATH"

};



const int messagetypes[] = {

	WM_USER, WM_USER, WM_USER, WM_USER, WM_USER, WM_USER, WM_USER, WM_USER, WM_USER, WM_USER, WM_USER, WM_USER,

	WM_USER, WM_USER, WM_USER, WM_USER, WM_USER, WM_COPYDATA, WM_COPYDATA, WM_COMMAND, WM_COMMAND, WM_COMMAND,

	WM_COMMAND, WM_COMMAND, WM_COMMAND, WM_COMMAND, WM_COMMAND, WM_COMMAND,  WM_COMMAND, WM_COMMAND, WM_COMMAND,

	WM_COMMAND, WM_COMMAND, WM_COMMAND, WM_COMMAND, WM_COMMAND, WM_COMMAND,  WM_COMMAND, WM_COMMAND, WM_COMMAND,

	WM_COMMAND, WM_COMMAND, WM_COMMAND, WM_COMMAND, WM_COMMAND, WM_USER

};



const int messagevalues[] = {

	IPC_GETVERSION,				IPC_GETTITLE,				IPC_DELETE,					IPC_STARTPLAY,

	IPC_ISPLAYING,				IPC_GETOUTPUTTIME,			IPC_JUMPTOTIME,				IPC_WRITEPLAYLIST,

	IPC_SETPLAYLISTPOS,			IPC_SETVOLUME,				IPC_SETPANNING,				IPC_GETLISTLENGTH,

	IPC_GETLISTPOS,				IPC_GETINFO,				IPC_GETEQDATA,				IPC_SETEQDATA,

	IPC_ADDBOOKMARK,			IPC_RESTARTWINAMP,			IPC_PLAYFILE,				IPC_CHDIR,

	WINAMP_OPTIONS_EQ,			WINAMP_OPTIONS_PLEDIT,		WINAMP_VOLUMEUP,			WINAMP_VOLUMEDOWN,

	WINAMP_FFWD5S,				WINAMP_REW5S,				WINAMP_BUTTON1,				WINAMP_BUTTON2,

	WINAMP_BUTTON3,				WINAMP_BUTTON4,				WINAMP_BUTTON5,				WINAMP_BUTTON1_SHIFT,

	WINAMP_BUTTON2_SHIFT,		WINAMP_BUTTON3_SHIFT,		WINAMP_BUTTON4_SHIFT,		WINAMP_BUTTON5_SHIFT,

	WINAMP_BUTTON1_CTRL,		WINAMP_BUTTON2_CTRL,		WINAMP_BUTTON3_CTRL,		WINAMP_BUTTON4_CTRL,

	WINAMP_BUTTON5_CTRL,		WINAMP_FILE_PLAY,			WINAMP_OPTIONS_PREFS,		WINAMP_OPTIONS_AOT,

	WINAMP_HELP_ABOUT,			IPC_GETPATH

};



const bool requiresparam[] = {

	false, false, false, false, false, true,  true,  false, true,  true,  true,  false, false, true,  true,

	true,  true,  false, true,  true,  false, false, false, false, false, false, false, false, false, false,

	false, false, false, false, false, false, false, false, false, false, false, false, false, false, false,

	false

};



const int messagecount = 46;



HWND hwndWinamp;



#if NDEBUG

typedef struct {

	DWORD	mVersion;

	HWND	mHwnd;

	BOOL	mKeep;

} LOADINFO;



void __stdcall LoadDll(LOADINFO *li) {

	return;

}



int __stdcall UnloadDll(int mTimeout) {

	if (mTimeout == 1)

		return 1;

	else

		return 0;

}

#endif



int __stdcall SendMsg(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause) {

	hwndWinamp = FindWindow("Winamp v1.x", NULL);

	if (hwndWinamp == NULL) return 1;

	int msgtype, msgvalue = -1, msgneedsparam, msgintparam = 0, i;

	char *msgstrparam;

	char params[2][1024], *space;

	strcpy(params[0], data);

	space = strpbrk(data, " ");

	if (space == NULL) {

		strcpy(params[1], "");

	}

	else {

		params[0][strcspn(params[0], " ")] = '\0';

		strcpy(params[1], strpbrk(data, " "));

	}

	for (i = 0; i < messagecount; i++) {

		if (stricmp(params[0], messages[i]) == 0) {

			msgtype = messagetypes[i];

			msgvalue = messagevalues[i];

			msgneedsparam = requiresparam[i];

			break;

		}

	}

	if (msgvalue < 0 || (msgneedsparam && strcmp(params[1], "") == 0))

		return 0;

	if (msgneedsparam) {

		msgstrparam = params[1];

		msgintparam = atoi(params[1]);

	}

	else {

		msgstrparam = 0;

		msgintparam = 0;

	}

	if (msgvalue == IPC_GETTITLE) {

		char apptitle[2048], *p;

		if (GetWindowText(hwndWinamp, apptitle, sizeof(apptitle)) == 0) return 1;

		if (strcspn(apptitle, "-") == 0) return 1;

		p = apptitle + strlen(apptitle) - 8;

		while (p >= apptitle) {

			if (!strnicmp(p, "- Winamp", 8)) break;

			p--;

		}

		if (p >= apptitle) p--;

		while (p >= apptitle && *p == ' ') p--;

		*++p = 0;

		char *temp;

		temp = strpbrk(apptitle, " ");

		if (temp == NULL) return 1;

		strcpy(data, temp);

	}

	else if (msgvalue == IPC_GETPATH) {
//old
		char szWinampPath[MAX_PATH], *szTemp;

		HKEY hKey;

		LONG lRet;

		DWORD dwBufLen = MAX_PATH;

		if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, TEXT("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\"

			"Winamp"), 0, KEY_QUERY_VALUE, &hKey) != ERROR_SUCCESS) return 1;

		if (lRet = RegQueryValueEx(hKey, TEXT("UninstallString"), NULL, NULL, (LPBYTE)szWinampPath,

			&dwBufLen) != ERROR_SUCCESS) return 1;

		szTemp = (char*)szWinampPath;

		szTemp++;

		szTemp[strlen(szTemp) - 14] = '\0';

		strcpy(data, szTemp);

	}

	else {

		int retval;

		if (msgtype == WM_COMMAND)

			retval = SendMessage(hwndWinamp, msgtype, msgvalue, 0);

		else

			retval = SendMessage(hwndWinamp, msgtype, msgintparam, msgvalue);

		if (msgvalue == IPC_GETVERSION) {

			sprintf(data, "%x", retval);

			data[2] = data[1];

			data[1] = '.';

		}

		else

			sprintf(data, "%i", retval);

	}

	return 3;

}





int Winamp::getPlaylistPosition() const

{

	HWND hwndWinamp;

	hwndWinamp = FindWindow("Winamp v1.x", NULL);

	if (hwndWinamp == NULL) return -1;

	return SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_GETLISTPOS)+1;

}


Winamp::Winamp()
{
	useStudio = false;
	//does not work yet
	//HKEY hKey;
	//if ((RegOpenKeyEx(HKEY_LOCAL_MACHINE, TEXT("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\"
	//		"Winamp3"), 0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)) useStudio = true; 
}



string Winamp::getPath() const
{
	char data[1024];
		char szWinampPath[MAX_PATH], *szTemp;
		HKEY hKey;
		LONG lRet;
		DWORD dwBufLen = MAX_PATH;
		//prefer winamp 3
		if (useStudio && (RegOpenKeyEx(HKEY_LOCAL_MACHINE, TEXT("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\"
			"Winamp3"), 0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)) 
		{
			if (lRet = RegQueryValueEx(hKey, TEXT("UninstallString"), NULL, NULL, (LPBYTE)szWinampPath,
				&dwBufLen) != ERROR_SUCCESS) return "ieps";
			szTemp = (char*)szWinampPath;
			//szTemp++;
			szTemp[strlen(szTemp) - 15] = '\0';
		}
		else
		{
			if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, TEXT("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\"
			"Winamp"), 0, KEY_QUERY_VALUE, &hKey) != ERROR_SUCCESS) return "ieps";
			if (lRet = RegQueryValueEx(hKey, TEXT("UninstallString"), NULL, NULL, (LPBYTE)szWinampPath,
				&dwBufLen) != ERROR_SUCCESS) return "ieps";
			szTemp = (char*)szWinampPath;
			szTemp++;
			szTemp[strlen(szTemp) - 14] = '\0';
		}
		strcpy(data, szTemp);
		return string(data);
}

int Winamp::getPlaylistLength() const

{
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	if (hwndWinamp == NULL) return -2;
	return SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_GETLISTLENGTH);
}







string Winamp::getRFileName() const 
{

/* (requires Winamp 2.04+, only usable from plug-ins (not external apps))
** char *name=
**
** IPC_GETPLAYLISTFILE gets the filename of the playlist entry [index].
** returns a pointer to it. returns NULL on error.
*/
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	if (hwndWinamp == NULL) return "";
	int pos=SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_GETLISTPOS);

	SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_WRITEPLAYLIST);

	ifstream* file = new ifstream(string(getPath() + "\\winamp.m3u").c_str());

	string word = "";

	char line[2048];
	char c;
	c = '0';
	int i = 0;
	int j = 0;

	while ((i != pos+1)) 
	{
		file->getline(line,2048);
		j++;
		if (line[0] != '#') i++;
	}
	file->close();

	delete file;

	return string(line);
}



bool Winamp::isPlaying() const
{
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	if (hwndWinamp == NULL) return false;
	return SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_ISPLAYING);
}

bool Winamp::isRunning() const
{
	return FindWindow("Winamp v1.x", NULL);
}


bool Winamp::inPlaylist(string filename) const
{
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	int pos=SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_GETLISTPOS);

	SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_WRITEPLAYLIST);
	QFile f(QString::fromLocal8Bit(string(getPath() + "\\winamp.m3u").c_str()));
	if (!f.open(IO_ReadOnly))
	{
		logWarning(string("Winamp::accessing playlist failed."));
		return false;
	}

	QTextStream t( &f );
	QString st1;
	QString st2 = QFileInfo(QString::fromLocal8Bit(filename.c_str())).filePath().lower();
	while (!t.atEnd())
	{
		st1 = QFileInfo(t.readLine()).filePath().lower();
			if (st1 == st2)
			{
				logDebug("Winamp::file in playlist!");
				f.close();
				return true;
			}
	}
	f.close();
	return false;
}

void Winamp::cleanPlayed(int newsize)
{
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	int pos=SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_GETLISTPOS);
	int size=SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_GETLISTLENGTH);

	ifstream* file = new ifstream(string(getPath() + "\\winamp.m3u").c_str());
	string word = "";
	char line[2048];
	char c;
	c = '0';
	int i = 0;
	int j = 0;

	if (size <= newsize) return;
//	while ((i != pos+1) && (size > newsize)) //does not work, as winamp will start playing the first song in the playlist when you queue another one

	//throw these away
	while ((i != pos+1)) 
	{
		file->getline(line,2048);
		if (line[0] != '#')
		{ i++; size--; }
	}
	vector<string> newvector;
	newvector.push_back(line);
	
	//ok, copy the rest
	while (!file->eof()) 
	{
		file->getline(line,2048);
		if (line[0] != '#') newvector.push_back(line);
	}

	SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_DELETE);
	queue(newvector);

} 

//this also cleans played
void Winamp::cleanQueued()
{
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	int pos=SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_GETLISTPOS);

	ifstream* file = new ifstream(string(getPath() + "\\winamp.m3u").c_str());
	string word = "";
	char line[2048];
	char c;
	c = '0';
	int i = 0;//i-th song
	int j = 0;

	while ((i != pos+1)) 
	{
		file->getline(line,2048);
		if (line[0] != '#') i++;
	}
	vector<string> newvector;
	newvector.push_back(line);

	//ok, now _don't_ copy the rest
	while (!file->eof()) 
	{
		file->getline(line,2048);

	}
	SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_DELETE);
	queue(newvector);

} 

int Winamp::getVolume()
{
	//TODO
	return 50;
}

void Winamp::setVolume(int vol)
{
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	int newvol = (vol*255) / 100;
	SendMessage(hwndWinamp ,WM_WA_IPC,newvol,IPC_SETVOLUME);
}

void Winamp::play()
{
	if (!isRunning())
	{
		char param[2048];
		param[0] = '\0';
		strcat(param, getPath().c_str());
		if (useStudio) strcat(param, "\\STUDIO.EXE");
		else strcat(param, "\\WINAMP.EXE");
		STARTUPINFO si;
		PROCESS_INFORMATION pi;

		ZeroMemory( &si, sizeof(si) );
		si.cb = sizeof(si);
		ZeroMemory( &pi, sizeof(pi) );

		if( !CreateProcess( NULL, // No module name (use command line). 
			param, // Command line. 
			NULL,             // Process handle not inheritable. 
			NULL,             // Thread handle not inheritable. 
			FALSE,            // Set handle inheritance to FALSE. 
			0,                // No creation flags. 
			NULL,             // Use parent's environment block. 
			NULL,             // Use parent's starting directory. 
			&si,              // Pointer to STARTUPINFO structure.
			&pi )             // Pointer to PROCESS_INFORMATION structure.
		) 
		{
			logWarning(string("Winamp::CreateProcess failed using") + param);
			logError("Could not start WinAmp. Is it correctly installed?");
		}
	}
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	if (isPlaying())
	SendMessage(hwndWinamp ,WM_COMMAND,WINAMP_BUTTON3, 0);
	else
	SendMessage(hwndWinamp ,WM_COMMAND,WINAMP_BUTTON2, 0);
	
}

void Winamp::next()
{
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	SendMessage(hwndWinamp, WM_COMMAND,WINAMP_BUTTON5,0);
}

void Winamp::previous()
{
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	SendMessage(hwndWinamp, WM_COMMAND,WINAMP_BUTTON1,0);
}

void Winamp::stop()
{
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	SendMessage(hwndWinamp, WM_COMMAND,WINAMP_BUTTON4,0);
}
int Winamp::getRSongLength() const
{
/**
** IPC_GETOUTPUTTIME returns the position in milliseconds of the 
** current song (mode = 0), or the song length, in seconds (mode = 1).
** Returns -1 if not playing or error.
*/

	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	return SendMessage(hwndWinamp ,WM_WA_IPC,1,IPC_GETOUTPUTTIME);
}
int Winamp::getSongPosition(void) const
{
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	return SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_GETOUTPUTTIME)/1000;
}
string Winamp::getRSongName() const
{
	if (useStudio) return getRFileName(); //does not work yet :(
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	if (hwndWinamp == NULL) return "";
		char apptitle[2048], *p;
		if (GetWindowText(hwndWinamp, apptitle, sizeof(apptitle)) == 0) return "";
		if (strcspn(apptitle, "-") == 0) return "";
		//pointerarithmetic...bleh!
		p = apptitle + strlen(apptitle) - 8;
		while (p >= apptitle) {
			if (!strnicmp(p, "- Winamp", 8)) break;
			p--;
		}
		if (p >= apptitle) p--;
		while (p >= apptitle && *p == ' ') p--;
		*++p = 0;
		char *temp;
		temp = strpbrk(apptitle, " ");
		if (temp == NULL) return "";
        if (*temp == ' ')
            temp++;
        return string(temp);
}

void Winamp::play(vector<string> filenames)
{
	if (filenames.empty()) return; //go fish 

	ofstream file("lpqueue.m3u");
	bool queued = false;
	for (uint i = 0;i<filenames.size();i++)
	{
		if (!filenames[i].empty())
		{
			file << filenames[i].c_str() << "\n";
			queued = true;
		}
	}
	file.close();
	if (!queued) return; //again, the fishing thing

	logDebug(string("Winamp::playing..."));
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_SET_SHUFFLE);
	char param[2048];
	param[0] = '\0';
	strcat(param, getPath().c_str());
		if (useStudio) strcat(param, "\\STUDIO.EXE");
		else strcat(param, "\\WINAMP.EXE");
	strcat(param, " lpqueue.m3u");

    STARTUPINFO si;
    PROCESS_INFORMATION pi;

    ZeroMemory( &si, sizeof(si) );
    si.cb = sizeof(si);
    ZeroMemory( &pi, sizeof(pi) );

    // Start the child process. 
    if( !CreateProcess( NULL, // No module name (use command line). 
        param, // Command line. 
        NULL,             // Process handle not inheritable. 
        NULL,             // Thread handle not inheritable. 
        FALSE,            // Set handle inheritance to FALSE. 
        0,                // No creation flags. 
        NULL,             // Use parent's environment block. 
        NULL,             // Use parent's starting directory. 
        &si,              // Pointer to STARTUPINFO structure.
        &pi )             // Pointer to PROCESS_INFORMATION structure.
    ) 
    {
		logWarning(string("Winamp::CreateProcess failed using") + param);
		logError("Could not start WinAmp. Is it correctly installed?");
    }

    // Wait until child process exits.
    if (isPlaying()) WaitForSingleObject( pi.hProcess, 5000 );
	logDebug(string("Winamp::executing. done."));

    // Close process and thread handles. 
    CloseHandle( pi.hProcess );
    CloseHandle( pi.hThread );
}

void Winamp::queue(vector<string> filenames)
{
	if (filenames.empty()) return; //go fish 

	ofstream file("lpqueue.m3u");
	bool queued = false;
	for (uint i = 0;i<filenames.size();i++)
	{
		if (!filenames[i].empty())
		{
			file << filenames[i].c_str() << "\n";
			queued = true;
		}
	}
	file.close();
	if (!queued) return; //again, the fishing thing

	logDebug(string("Winamp::executing..."));
	HWND hwndWinamp;
	hwndWinamp = FindWindow("Winamp v1.x", NULL);
	SendMessage(hwndWinamp ,WM_WA_IPC,0,IPC_SET_SHUFFLE);
	char param[2048];
	param[0] = '\0';
	strcat(param, getPath().c_str());
		if (useStudio) strcat(param, "\\STUDIO.EXE");
		else strcat(param, "\\WINAMP.EXE");
	strcat(param, " /ADD");
	strcat(param, " lpqueue.m3u");

    STARTUPINFO si;
    PROCESS_INFORMATION pi;

    ZeroMemory( &si, sizeof(si) );
    si.cb = sizeof(si);
    ZeroMemory( &pi, sizeof(pi) );

	// Start the child process. 
    if( !CreateProcess( NULL, // No module name (use command line). 
        param, // Command line. 
        NULL,             // Process handle not inheritable. 
        NULL,             // Thread handle not inheritable. 
        FALSE,            // Set handle inheritance to FALSE. 
        0,                // No creation flags. 
        NULL,             // Use parent's environment block. 
        NULL,             // Use parent's starting directory. 
        &si,              // Pointer to STARTUPINFO structure.
        &pi )             // Pointer to PROCESS_INFORMATION structure.
    ) 
     {
		logWarning(string("Winamp::CreateProcess failed using") + param);
		logError("Could not start WinAmp. Is it correctly installed?");
    }

    // Wait until child process exits.
    if (isPlaying()) WaitForSingleObject( pi.hProcess, 5000 );
	logDebug(string("Winamp::executing. done."));

    // Close process and thread handles. 
    CloseHandle( pi.hProcess );
    CloseHandle( pi.hThread );

}
#endif
