/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifdef _WINDOWS
#ifndef H_WINAMP
#define H_WINAMP

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <windows.h>
#include "frontend.h"

#include "lpglobal.h"
#include "absplayer.h"

/** absPlayer implementation for Winamp 2.x and Winamp 5.x
 */
class Winamp : public absPlayer {
public:
	Winamp();
	virtual void play(vector<string> filename);
	virtual void queue(vector<string> filename);
	virtual int getPlaylistPosition() const;
	virtual int getPlaylistLength() const;
	virtual bool isPlaying() const;
	virtual bool isRunning() const;
	
	virtual int getVolume();
	virtual void setVolume(int);

	virtual void play();
	virtual void next();
	virtual void previous();
	virtual void stop();

	virtual bool inPlaylist(string filename) const;
	virtual void cleanPlayed(int newsize);
	virtual void cleanQueued();
	virtual string getPath() const;
	virtual int getSongPosition() const;
private:
	virtual string getRSongName() const;
	virtual int getRSongLength() const;
	virtual string getRFileName() const;
	bool useStudio;
};


#endif
#endif
