/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2002 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifdef _WINDOWS
#ifndef H_WINAMP3
#define H_WINAMP3

#include "lpglobal.h"
#include "absplayer.h"

#include "resource.h"
#include "../../studio/api.h" 
#include "../../bfc/canvas.h" 
#include "../../bfc/bitmap.h" 
#include "../../bfc/wnds/buttwnd.h" 
#include "../../bfc/msgbox.h"
#include "../../common/script/c_script/c_guiobject.h"
#include "../../common/script/c_script/c_group.h"
#include "../../common/script/scriptguid.h"

#include "../../common/corehandle.h"

#include "../../studio/consolecb.h"
#include "../../studio/corecb.h"
#include "../../studio/sequence.h"
/*
class Winamp3CB : public CoreCallbackI  {
  virtual ~Winamp3CB();

  virtual int onInit();

  virtual int corecb_onTitleChange(const char *title);
};
*/
class Winamp3 : public absPlayer, public CoreCallbackI /* TimerClientDI , public ItemSequencerI */ {
public:

	Winamp3(ComponentAPI* myApi);
	virtual ~Winamp3();
	virtual void play(vector<string> filename);
	virtual void queue(vector<string> filename);
	virtual int getPlaylistPosition() const;
	virtual int getPlaylistLength() const;
	virtual bool isPlaying() const;
	virtual bool isRunning() const;
	
	virtual int getVolume();
	virtual void setVolume(int);

	virtual void play();
	virtual void next();
	virtual void previous();
	virtual void stop();

	virtual bool inPlaylist(string filename) const;
	virtual void cleanPlayed(int newsize);
	virtual void cleanQueued();
	virtual string getPath() const;

	virtual int getSongPosition() const;
	virtual void setRSongName(string);
	virtual void setIsPlaying(bool);
	virtual void setRFileName(string);
/*
  virtual int rewind();
  virtual int forward();
  virtual const char *getNextPlayItem();
*/
  //virtual void timerclient_timerCallback(int id);

  // =========================================================================
  // CoreCallbackI functions

  // Basic Events
  virtual int corecb_onStarted();
  virtual int corecb_onStopped();
  virtual int corecb_onPaused();
  virtual int corecb_onUnpaused();
  virtual int corecb_onSeeked(int newpos);

  // Volume & EQ Events
  virtual int corecb_onVolumeChange(int newvol);
  virtual int corecb_onEQStatusChange(int newval);
  virtual int corecb_onEQPreampChange(int newval);
  virtual int corecb_onEQBandChange(int band, int newval);

  // Info Events
  virtual int corecb_onTitleChange(const char *title);
  virtual int corecb_onTitle2Change(const char *title, const char *title2);
  virtual int corecb_onInfoChange(const char *info);
  virtual int corecb_onUrlChange(const char *url);

  // Source Events
  virtual int corecb_onNextFile();
  virtual int corecb_onNeedNextFile(int fileid);
  virtual int corecb_onAbortCurrentSong();
  virtual int corecb_onEndOfDecode();

  // Bad Events.
  virtual int corecb_onErrorOccured(int severity, const char *text);
  virtual int corecb_onStatusMsg(const char *text);
  virtual int corecb_onWarningMsg(const char *text);
  virtual int corecb_onErrorMsg(const char *text);

private:
	string _rtitle;
	string _rfilename;
	bool _rplaying;

	//temp stuff for info that can't be set in another thread
	int _rcurpos, _rtotalpos;

	virtual string getRSongName() const;
	virtual int getRSongLength() const;
	virtual string getRFileName() const;
	ComponentAPI* _api;
	 
};


#endif
#endif
