#ifndef _WS_WIN_
#include "xmms.h"
#include "absutil.h"
#include "lpsettings.h"

#include <qfile.h>
#include <qfileinfo.h>
#include <qtextstream.h>
#include <qdir.h>

#include <unistd.h>
#include <xmmsctrl.h>
#include <sys/stat.h>
#include <fstream>
#include <unistd.h>
#include <stdio.h>
#include <pthread.h>

//Credit: Andrew Bednarz (bed42@primus.com.au) http://www.geocities.com/Hollywood/2430

int XMMS::getPlaylistPosition() const {
	int session = 0;
    if( xmms_remote_is_running( session ) ) {
		return xmms_remote_get_playlist_pos(session)+1;
    }
    return 1;
}

void XMMS::play() { xmms_remote_play_pause(0); }
void XMMS::stop() { xmms_remote_stop(0); }
void XMMS::next() { xmms_remote_playlist_next(0); }
void XMMS::previous() { xmms_remote_playlist_prev(0); }
int XMMS::getVolume() { return xmms_remote_get_main_volume(0); }
void XMMS::setVolume(int vol) { xmms_remote_set_main_volume(0,vol); }
string XMMS::getPath() const { return ""; }
bool XMMS::isPlaying() const { return xmms_remote_is_playing( 0 ); }
bool XMMS::isRunning() const { return xmms_remote_is_running( 0 ); }

void XMMS::setVars(string& title,string& filename,int& length) const {
	char* temptitle;
	char* tempfilename;
	int session = 0;
	if (!xmms_remote_is_running(session)) {
		length = 0; title = ""; filename = "";
		return;
	}
	else {
		int pos =  xmms_remote_get_playlist_pos(session);
		length =  xmms_remote_get_playlist_time(session,pos);
 		temptitle = xmms_remote_get_playlist_title(0,pos);
		tempfilename = xmms_remote_get_playlist_file(0,pos);
		if (temptitle) title = string(temptitle);
		if (tempfilename) filename = string(tempfilename);
		free(temptitle); 
		free(tempfilename); 
		return;
	}
}

int XMMS::getPlaylistLength() const {
    int session = 0;
    if( xmms_remote_is_running( session ) ) {
       return xmms_remote_get_playlist_length( session );
	}
	return 1;
}

string XMMS::getRFileName() const {
	int length; string title,filename;
	setVars(title,filename,length);
	return filename;
}

bool XMMS::inPlaylist(string filename) const {
		char* tempfilename;
		int n =  xmms_remote_get_playlist_length(0);
		for (int i=0;i < n; i++) {
			tempfilename = xmms_remote_get_playlist_file(0,i);
		 	if (filename == string(tempfilename)) {
					free(tempfilename);
					return true;
			}
			free(tempfilename);
		}				
		return false;
}

void XMMS::cleanPlayed(int newsize) {
		int n =  xmms_remote_get_playlist_pos(0);
		int size = xmms_remote_get_playlist_length(0);
		for (int i=0;(i < n-1) && (size > newsize); i++) {
		 	xmms_remote_playlist_delete(0,0); size--;
		}				
}

void XMMS::cleanQueued() {
		int n =  xmms_remote_get_playlist_pos(0);
		int m = getPlaylistLength();
		for (int i=n+1;i < m; i++) {
		 	xmms_remote_playlist_delete(0,n+1);
		}				
}

int XMMS::getSongPosition() const {
        if (!xmms_remote_is_running(0)) { return 0; }
        else { return xmms_remote_get_output_time(0)/1000; }
}

int XMMS::getRSongLength() const {
	int length; string title,filename;
	setVars(title,filename,length);
	return length/1000;
}

string XMMS::getRSongName() const {
	int length; string title,filename;
	setVars(title,filename,length);
	return title;
}

void XMMS::play(vector<string> filenames) {
	string file2q;
	file2q = LPSettings::getLPHomeDir() + "/queue.m3u";

	ofstream file(file2q.c_str());
	for (uint i = 0;i<filenames.size();i++) { 
		file << filenames[i].c_str() << "\n"; 
	}
	file.close();

	pid_t process_id;
	if((process_id = fork()) == 0) {
		logDebug(string( "XMMS::executing play ") + "xmms" + " " + file2q);
		execlp("xmms", "xmms&",file2q.c_str(),0);
	}
}
	
void XMMS::queue(vector<string> filenames) {
	if (!xmms_remote_is_running(0)) {
		play(filenames); return;
	}
		
	string file2q;
	file2q = LPSettings::getLPHomeDir() + "/queue.m3u";
	ofstream file(file2q.c_str());
	for (uint i = 0;i<filenames.size();i++) {
        file << filenames[i].c_str() << "\n";
	}
	file.close();
	
	GList *lista=NULL;
	char mystr[256];
	strcpy(mystr,file2q.c_str());
	lista = g_list_append(lista, mystr);
	xmms_remote_playlist_add(0, lista);
}
#endif
