/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef abslogh
#define abslogh

#include <string>

using namespace std;

/** AbsLog.h - an abstract class for handling all kinds of user- and developer related messages
 */

class absLog {
public:
	/** singleton getter */
	static absLog* getLog();

	/* update GUI progress indication
	 * may be called from any thread 
	 * pre: progressInit(text, steps) where steps >= step
	 */
	virtual bool progressSet(int step)=0;

	/* initiate GUI progress indication
	 * may be called from any thread 
	 * but only 1 progress indication may happen at a time!
	 * TODO return some sort of progress object
	 */
	virtual void progressInit(string text, int steps)=0;
	virtual void progressEnd()=0;

	/** if valid filename, logs all subsequent messages to the file;
	 *  it is flushed when the logger is destroyed
	 * */
	virtual void setLogFile(string filename)=0;
	/** if true, displays debugging information */
	virtual void setDebug(bool)=0;
	
	/** used to record debugging messages */
	virtual void debug(int text)=0;
	virtual void debug(string text)=0;

	/** displays a message to the user */
	virtual void message(string text)=0;

	/* normal message (purely informative, high entertainment value)
	 * if displaylength == 0 => message stays visible until next message
	 */
	virtual void info(string text, int displaylength=0)=0;

	/** severe error message  */
	virtual void error(string text)=0;

	/** please evacuate the building... */
	virtual void oops(string text)=0;

	/** recoverable error message, not noticed by the user */
	virtual void warning(string text)=0;

	virtual void busy(string text, bool modal)=0;

	/** should be same text as used at busy */
	virtual void ready(string text)=0;
private:
	static absLog* _absLog;
	
};

#endif
