/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_ABSUTIL
#define H_ABSUTIL

#include <string>
#include <qglobal.h>

using namespace std;

/**
 * absUtil.h: provides an abstract interface to some generally useful and/or 
 * operating system dependant functions
 */
class absUtil
{
public:

	/** Time functions */
	/** returns the amount of seconds elapsed since Jan 1st 1970 midnight
	 */
	int date();

	/** returns a random value between 0 and 1
	 */
	virtual double random();

	/** File operations */
	/** returns the size of the file with the given filename in bytes */
	virtual int getSize(string filename);

	/** calculates a fast CRC-like value of the file with the given filename */
	virtual string getFileID(string filename);

	/** copies file from filename1 to filename2 
	 * pre: filename1 != filename2, filename1 exists
	 */
	virtual bool copyFile(string filename1, string filename2);

	/** returns true if file exists */
	virtual bool existsFile(string filename);

	/** removes file from disk (depending on platform: to recycle bin) */
	virtual bool removeFile(string filename, bool recyclebin=false);

	/** singleton */
	static absUtil* getUtil();
	static void setUtil(absUtil*);

	/** converts a float to a string */
	static string fts(float nr);
	/** converts an integer to a human readable string */
	static string its(int nr);
	/** converts an integer to a hexadecimal string of 8 characters */
	static string iths(uint nr);
	/** converts a double to a human readable string */
	static string dts(double nr);
	/** converts a span in seconds to a human readable -non-exact- timespan */
	static string longTimeSpan(int secs);
	/** converts a span in seconds to a minutes:seconds notation */
	static string shortTimeSpan(int secs);
	/** converts a span in milliseconds to human readable timespan */
	static string milliTimeSpan(int millis);

	/** returns a copy of the string in uppercase */
	static string uppercase(string);
	absUtil();

protected:
	/** to prepare functions, should be called once */
	virtual void init();

private:
	//functions for random number generation
	void initRandomGenerator();
	int randomNumber( int lowerb, int upperb );
	int randomMM();
	int rgiState[2+55]; 

	static absUtil* util;

	//functions for CRC generation
	virtual uint GetCRC(unsigned char* data, int size);
	// Call this function only once to initialize the CRC table.
	void initCRC32Table();

	uint crc32_table[256];//Lookup table array
	uint reflect(uint ref, char ch);
};
	
#endif
