#include "autoqueue.h"

#include "absplayer.h"
#include "queuebuilder.h"
#include "lplayer.h"
#include "lpsettings.h"

IntSetting AutoQueue::SettingAmount("queue","aheadmax",5);

AutoQueue::AutoQueue(LPlayer* lplayer, absPlayer* mplayer) : _stop(false), _done(true), _force(false), _lplayer(lplayer), _mplayer(mplayer) { }

AutoQueue::~AutoQueue() { }

LPlayer* AutoQueue::getLPlayer() { return _lplayer; }
absPlayer* AutoQueue::getMPlayer() { return _mplayer; }
LPSettings* AutoQueue::getSettings() { return getLPlayer()->getSettings(); }
void AutoQueue::setForce(bool b) { _force = b; }
bool AutoQueue::done() { return _done; }

void AutoQueue::start() {
	_stop = false;
	_done = false;
	bool force = _force; //this might change while we are executing

    vector<string> list;
    Playlist *playlist = getLPlayer()->getBuiltPlaylist();
    if (!playlist->filenames()->size()) {       
        logInfo("Could not find songs matching playlist description.");
		_done = true;
        return;
    }       
    //e.g. 20 songs, playing 15th, need to stay 5 ahead -> amount = 20 - 15 - 5 = 0
    int amount = getLPlayer()->getSettings()->getSetting(SettingAmount) - (absPlayer::getPlayer()->getPlaylistLength() - absPlayer::getPlayer()->getPlaylistPosition() );
    if (force) amount = getLPlayer()->getSettings()->getSetting(SettingAmount);
    if (amount <= 0) {
        logDebug("AutoQueue::no queueing necessary.");
		_done = true;
		return;
	}
    list = getLPlayer()->getQueueBuilder()->getQueue(playlist,amount);
	if (_stop) { 
        logDebug("AutoQueue::aborted.");
		_done = true; return; 
	}
    if (list.size()) {
		string strSongs = (list.size() == 1) ? " song" : " songs";
        logBusy(string("Queueing ") + absUtil::its(list.size()) + strSongs + "..",0);
        if (force) getLPlayer()->getPlayer()->play(list);
            else getLPlayer()->getPlayer()->queue(list);
        logReady(string("Queueing ") + absUtil::its(list.size()) + strSongs + "..");
        logInfo(string("Queued ") + absUtil::its(list.size()) + strSongs + ".", 3000);
    }
    else {
        logInfo("Could not find random songs to queue.");
    }
    logDebug("AutoQueue::queueing finished.");
	_done = true;
}

void AutoQueue::stop() {
	_stop = true;
	getLPlayer()->getQueueBuilder()->abort();
}

