#ifndef AutoQueue_H
#define AutoQueue_H

#include "lpsong.h"
#include "command.h"
#include "lpsettings.h"

class LPlayer;
class absPlayer;

/** class that queues new songs when necessary */
class AutoQueue : public Command {

public:
	static IntSetting SettingAmount;

	AutoQueue(LPlayer*,absPlayer*);
	virtual ~AutoQueue();

	void start();
	void stop();
	bool done();

	void setForce(bool);
private:
	bool _stop;
	bool _done;
	bool _force;

	LPlayer* getLPlayer();
	absPlayer* getMPlayer();
	LPSettings* getSettings();

	LPlayer* _lplayer;
	absPlayer* _mplayer;
};
#endif
