#include "callbackwnd.h"
#include "lpwac.h"
#include "resource.h"

#include "../../studio/api.h"
#include "../../bfc/wnds/buttwnd.h"
#include "../../common/framewnd.h"
#include "../../bfc/notifmsg.h"

#include <qapplication.h>
#include "lpguihandler.h"
#include "lpsettings.h"
#include "logwa.h"
#include "lpfactory.h"
#include "lplistener.h"
#include "winamp3.h"
#include "utilwin.h"
#include "lpfacade.h"

CallbackWnd::CallbackWnd() {
    FrameWnd* horiz = new FrameWnd();
    horiz->setName("Frames");  // Remember, the name of the object is the
                                  // name on the tab in the stabsheet buttonbar.

    //  *** Important Options for FrameWnd.
    // Set some preinitialization parameters, like which way to divide,
    horiz->setDividerType(DIVIDER_HORIZONTAL);
    // Setting the object resizable makes a divider get created that's moveable
//    horiz->setResizeable(TRUE);
    // And this simply allows us to set the divider position to whatever we'd like it to be.
    horiz->setDividerPos(SDP_FROMTOP, 50);
  //    In the top section, we will create:
  //      A ContWnd containing:
    ContWnd *container = new ContWnd();
  //        A button and
    ButtonWnd *go = new ButtonWnd();
    go->setButtonText("Go", 16);
    go->setNotifyId(LP_FRAMEBUTTON1);
    go->setNotifyWindow(this);
    container->addChild(go, 11, (10 * 2), 60, 25, 1);
  //        A text edit field.
//myFrameEditWnd = new ExampleCodeGUIEditWnd(this);
//myFrameEditWnd->setName(_("This is a text edit field."));
//container->addChild(myFrameEditWnd,       EXB_LEFT_OFFSET + EXB_BUTTON_WIDTH + EXB_BUTTON_SPACER,      (EXB_TOP_OFFSET * 2), EXB_BUTTON_WIDTH * 6, EXB_BUTTON_HEIGHT, 1);
//    myFrameEditWnd->setBuffer(String(_("This is a text edit field.")),EXB_EDIT_BUFFSIZE);
  //    In the bottom section, we will create:
  //      A Vertical Frame Split.
    FrameWnd *vert = new FrameWnd();
    // set the frame options.
    vert->setDividerType(DIVIDER_VERTICAL);
    vert->setResizeable(TRUE);
    vert->setDividerPos(SDP_FROMLEFT, 50);
	// In the left section, we will create:
	_playlists = new ListWnd();
	_playlists->insertColumn(new ListColumn("Playlist", TRUE));
    _playlists->setNotifyId(LP_PLSELECT);
    _playlists->setNotifyWindow(this);
	_playlists->addItem("test", 0);
     //_list->ensureItemVisible(_list->getNumItems()-1);

	_list = new ListWnd();
	_list->insertColumn(new ListColumn("Message", TRUE));

	/*
	//          A TreeWnd Data Tree with:
    myFrameTreeWnd = new TreeWnd;
	//            10 TreeItem items.
    int i = 0;
    for ( i = 0; i < 10; i++ ) {
      // Create a tree item
      ExampleCodeGUITreeItem * newNode = new ExampleCodeGUITreeItem(this, i+1);
      // Give it a label -- if you don't give it a label, you'll ASSERT.
      newNode->setLabel(StringPrintf("Item %02d", i+1));
      // Attach our tree connections.
      myFrameTreeWnd->addTreeItem(newNode, NULL, FALSE, TRUE);
    }

  //        In the right section, we will create:
  //          A ContWnd containing:
    myFrameContWnd = new ContWnd;
  //            Either a text bar or
  //            A button,
  //          Depending on certain conditions (see below).

  //
  // And then we commit final assembly of our major pieces:
  //
    // the tree and the cont into the bottom frame
  */
//    vert->setChildren(myFrameTreeWnd, myFrameContWnd);
    // the editwnd/gobutton and the bottom frame in the main frame.
//  addChild(_list, 0, 0,100, 100, 1);
    vert->setChildren(_playlists, _list);
    horiz->setChildren(container, vert);
    // and then the main frame object .
    addChild(horiz,0, 0,200, 400, 1);
  //
  // This method call sets up children for myFrameContWnd....
//    displayText(_("This is the ``Frames`` tab."));
    // displayText() will make sure a text object exists in the myFrameContWnd
    // displayButton() will make sure a buttonobject exists in the myFrameContWnd
    // each will remove the contents of myFrameContWnd when they are executed.
}

bool CallbackWnd::event(QEvent* e)
{
	if (e->type() ==  QEvent::User )
	{
		if (LPGUIEvent *lpe = (LPGUIEvent*)(e) )
		{
  corecb_outputString(lpe->getMessage().c_str());
			return true;
		}
	}
	return false;

}
void CallbackWnd::onDestroy() {
}

int CallbackWnd::onInit() {
	CALLBACKWND_PARENT::onInit();
	ContWnd::setName("LongPlayer");

	//connect to LongPlayer!
	_logger = (LogWA*) globalclass::getLogger();
	_logger->setOutput(this);
    _logger->setListener(this);

	_facade = LPFactory::getLPFactory()->getFacade();
	_amp = (Winamp3*) absPlayer::getPlayer();

	return 1;
}

CallbackWnd::~CallbackWnd() {
	//NO OUTPUT from now on...
	//delete _list; _list = NULL; //automatically?
    _logger->setListener(0);
	_logger->setOutput(0);
}


// =========================================================================
//
//  Methods required by Window Creation Services
//
const char *CallbackWnd::getWindowTypeName() { return "LongPlayer Window"; }
GUID CallbackWnd::getWindowTypeGuid() { return the->getGUID(); }
void CallbackWnd::setIconBitmaps(ButtonWnd *button) {
  button->setBitmaps(the->gethInstance(), IDB_TAB_NORMAL, NULL, IDB_TAB_HILITED, IDB_TAB_SELECTED);
}

int CallbackWnd::corecb_outputString(const char *string) {
  _list->addItem(string, 0);
  if (_list->getNumItems() > 128)	// FUCKO: make configurable
    _list->deleteByPos(0);
  _list->ensureItemVisible(_list->getNumItems()-1);
  return 1;
}

int CallbackWnd::childNotify (RootWnd *which, int msg, int param1, int param2) {
//  StringPrintf text("Incoming childNotify: ptr:0x%08x msg:0x%04x p1:0x%08x p2:0x%08x \n",
  //      which, msg, param1, param2);
//  OutputDebugString(text);

// for an interesting reason, it is valid to be given NULL as a which pointer.
if (which == NULL) return CALLBACKWND_PARENT::childNotify(which, msg, param1, param2);

  int objId = which->getNotifyId();
  switch(msg)  {
    // Messages from our buttons being pushed.
    case ChildNotify::BUTTON_LEFTPUSH: {
      //
      // So, now, what we're going to do here is if ANY of those
      // messages came in, we just check which object ID shot that
      // message out in order to know what to do with it.
      //
      // Switch on the ID to know what to do.
      switch(objId) {
/*
	  case EXB_PREVIOUS: {
          OutputDebugString(_("Button pushed corresponds to EXB_PREVIOUS ButtonID\n"));
          CoreHandle newHandle;
          newHandle.prev();
        }
        break;
        case EXB_PLAY: {
          OutputDebugString(_("Button pushed corresponds to EXB_PLAY ButtonID\n"));
          CoreHandle newHandle;
          newHandle.play();
        }
        break;
        case EXB_PAUSE: {
          OutputDebugString(_("Button pushed corresponds to EXB_PAUSE ButtonID\n"));
          CoreHandle newHandle;
          newHandle.pause();
        }
        break;
        case EXB_STOP: {
          OutputDebugString(_("Button pushed corresponds to EXB_STOP ButtonID\n"));
          CoreHandle newHandle;
          newHandle.stop();
        }
        break;
        case EXB_NEXT: {
          OutputDebugString(_("Button pushed corresponds to EXB_NEXT ButtonID\n"));
          CoreHandle newHandle;
          newHandle.next();
        }
        break;
		*/
        //
        // These two buttons are created and handled in examplebframewnd.cpp
        case LP_PLSELECT:
          logDebug("Playlist selected");
//		  _facade->queue();
//          onFrameButton1();
        break;
        case LP_FRAMEBUTTON1:
          logDebug("Button pushed");
		  _facade->queue();
//          onFrameButton1();
        break;
        //
//        default:
//		  return CALLBACKWND_PARENT::childNotify(which, msg, param1, param2);
      }
    }
    break;
    case ChildNotify::BUTTON_RIGHTPUSH:
    case ChildNotify::BUTTON_LEFTDOUBLECLICK:
    case ChildNotify::BUTTON_RIGHTDOUBLECLICK:
      // We don't really do anything with these messages.
    break;
    // In addition to buttons, we can also be notified about the movement of
    // sliders in our UI.  In this case, we're notified both _as_ the object
    // moves, and we're notified that it is done moving.
    //
    //    SLIDER_INTERIM_POSITION - The slider is moving and this is where it
    //                              currently resides.
    //    SLIDER_FINAL_POSITION   - The slider is done moving and this is
    //                              where it has stopped.
    //
    // I'm going to be a bit redundant in how I split out these notifications,
    // but it will hopefully give you a clearer picture of how these two work.
    //
    //  So, here's where we track the sliders as they move...
    case ChildNotify::SLIDER_INTERIM_POSITION:
/*
	{
      int SliderPos = param1; // Just a clarification assignment.
      switch (objId) {
        case EXB_MINEVERTSLIDER:
          OutputDebugString(_("The vertical size slider is moving.\n"));
          displayVert(SliderPos); // In raw slider units.
        break;
        case EXB_MINEHORIZSLIDER:
          OutputDebugString(_("The horizontal size slider is moving.\n"));
          displayHoriz(SliderPos); // In raw slider units.
        break;
        case EXB_MINEMINESSLIDER:
          OutputDebugString(_("The number of mines slider is moving.\n"));
          calcMines();
        break;
      }
    }
	  */
    break;
    //  So, here's where we track the sliders when they complete their movement...
    case ChildNotify::SLIDER_FINAL_POSITION:

/*		{
      int SliderPos = param1; // Just a clarification assignment.
      switch (objId) {
        case EXB_MINEVERTSLIDER:
          OutputDebugString(_("The vertical size slider has stopped moving.\n"));
          displayVert(SliderPos); // In raw slider units.
        break;
        case EXB_MINEHORIZSLIDER:
          OutputDebugString(_("The horizontal size slider has stopped moving.\n"));
          displayHoriz(SliderPos); // In raw slider units.
        break;
        case EXB_MINEMINESSLIDER:
          OutputDebugString(_("The number of mines slider has stopped moving.\n"));
          calcMines();
        break;
      }
    }
	  */
    break;
    case ChildNotify::CHECKWND_CLICK:
    case ChildNotify::RADIOGROUP_STATECHANGE:
      // To attempt to prevent confusion, we will handle these two event types
      // in depth in ExampleCodeGUIChecklistWnd.cpp --
//      return handleChecklistNotify(msg, objId, param1, param2);
    break;
    case ChildNotify::DROPLIST_SEL_CHANGED:
//			return handleDroplistChanged(msg, objId, param1, param2);
		break;

//    default:
      // Hrrmph.
  }
 return CALLBACKWND_PARENT::childNotify(which, msg, param1, param2);

}


