#include "compositeplaylist.h"
#include "absutil.h"

const int CompositePlaylist::TYPE = 10;	

int CompositePlaylist::getType() { return TYPE; }
CompositePlaylist::CompositePlaylist() : Playlist("noname") {}
CompositePlaylist::~CompositePlaylist() {
	for (uint i=0;i<getPlaylists().size();i++) {
		delete getPlaylists()[i];	
	}
}

CompositePlaylist::CompositePlaylist(string name) : Playlist(name) {}
bool CompositePlaylist::equals(Playlist* list) {
	logDebug("compositeplaylist::equals");
	if (list->getType() != TYPE) return false;
	CompositePlaylist* clist = (CompositePlaylist*) list;
	if (clist->getPlaylists().size() != getPlaylists().size()) return false;
	for (uint i=0;i<_playlists.size();i++)
		if (!_playlists[i]->equals(clist->getPlaylists()[i])) return false;
	logDebug("compositeplaylist::equals passed.");
	return Playlist::equals(list);
}

void CompositePlaylist::removePlaylist(string playlist) {
	vector<Playlist*> temp = _playlists;
	_playlists.clear();
	for (uint i=0;i < temp.size();i++) {
		if (getPlaylists()[i]->getName() == playlist) delete getPlaylists()[i];
		else addPlaylist(getPlaylists()[i]);
	}
}

void CompositePlaylist::addPlaylist(Playlist* playlist) {
	_playlists.push_back(playlist);
	playlist->setFilter(this);
}

vector<Playlist*> CompositePlaylist::getPlaylists() {
	return _playlists;
}

void CompositePlaylist::buildStep(vector<string>* temp) {
	int built = true;
    for (uint i=0;i<_playlists.size();i++) {
		_playlists[i]->buildStep(temp);
		if (!_playlists[i]->getBuilt()) built = false;
    }
	_buildMutex->lock();
	_built = built;
	_buildMutex->unlock();
}

void CompositePlaylist::buildCleanup(vector<string>* temp) {
    for (uint i=0;i<_playlists.size();i++) {
		_playlists[i]->buildStep(temp);
	}
}

void CompositePlaylist::buildInit(vector<string>* temp){
    logDebug(string("CompositePlaylist::building list of files..."));
   	int built = true;
    for (uint i=0;i<_playlists.size();i++) {
		_playlists[i]->_abort = false;
		_playlists[i]->buildInit(temp);
		if (!_playlists[i]->getBuilt()) built = false;
    }
    logDebug(string("CompositePlaylist::building list... done (") + absUtil::its(temp->size()) + " files)");
	_buildMutex->lock();
	_built = built;
	_buildMutex->unlock();
}

void CompositePlaylist::stopBuilding() {
    for (uint i=0;i<_playlists.size();i++) {
		_playlists[i]->stopBuilding();
	}	
	Playlist::stopBuilding();
}
