#include "filewriter.h"
#include "lpsettings.h"
#include "absplayer.h"

#include <qfile.h>
#include <qdir.h>

#include <fstream>

fileWriter::fileWriter(LPlayer* player) {
	_player = player;
	player->subscribe(this);
}

fileWriter::~fileWriter() {
	string filename = getLPlayer()->getSettings()->getLPHomeDir() + "/currentsong.txt";
	QFile::remove(QString::fromLocal8Bit(filename.c_str()));
}

LPlayer* fileWriter::getLPlayer() { return _player; }

//don't forget to update the header if you change this!
void fileWriter::notify(int /*i*/) {
	logDebug("fileWriter::saving currentsong.txt file...");
	string filename = getLPlayer()->getSettings()->getLPHomeDir() + "/currentsong.txt";
	ofstream ofile( filename.c_str() );
	Song s = getLPlayer()->currentSong();
	ofile << s.getName().c_str() << "\n";
	ofile << s.getFilename().c_str() << "\n";
	ofile << s.getDate() << "\n";
	ofile << s.getTimes() << "\n";
	ofile << s.getLike() + 5 << "\n";
	ofile << s.length() << "\n";
	ofile.close();
}
