/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef GENREWIDGET_H
#define GENREWIDGET_H

#include <qframe.h>

class GenreConstraintWidget : public QFrame {
    Q_OBJECT
	public:
	    GenreConstraintWidget(QWidget*, const char*);
	    ~GenreConstraintWidget();
		void getConstraint(int* x1, int* y1, int* x2, int* y2);
		void setConstraint(int x1,int y1, int x2,int y2);
		void setEnabled(bool b);
		void setMessage(QString s);
	signals:
		void constraintChanged(int, int, int,int);
	protected:
	    void drawIt( QPainter * );
	    void paintEvent( QPaintEvent * );
	    void resizeEvent( QResizeEvent * );
		void mouseReleaseEvent(QMouseEvent* e);
		void mousePressEvent(QMouseEvent* e);
		void mouseMoveEvent(QMouseEvent *e);
	private:
		QPixmap *pict, *pictEnabled, *pictDisabled;
		QString _message;
		int x1, y1, x2, y2;
};

class GenreWidget : public QFrame {
    Q_OBJECT
	public:
	    GenreWidget(QWidget*, const char*);
	    ~GenreWidget();
		void setMessage(QString s);
		void setEnabled(bool b);
		void setGenre(int x,int y,int z);
	signals:
		void genreChanged(int, int, int);
	protected:
	    void drawIt( QPainter * );
	    void paintEvent( QPaintEvent * );
	    void resizeEvent( QResizeEvent * );
		void mouseReleaseEvent(QMouseEvent* e);
	private:
		QPixmap *pict, *pictEnabled, *pictDisabled;
		int x, y, z;
		bool editable;
		QString _message;
};

#endif
