/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_ITUNES
#define H_ITUNES

#include "lpglobal.h"
#include "absplayer.h"

class CocoaScript;
class QMutex;

class ITunes : public absPlayer {
public:
	ITunes();
	~ITunes();
	virtual void play(vector<string> filename);
	virtual void setVolume(int vol);
	virtual int getVolume();
	virtual void play();
	virtual void next();
	virtual void previous();
	virtual void stop();
	virtual void queue(vector<string> filename);
	virtual int getPlaylistPosition() const;
	virtual int getPlaylistLength() const;
	virtual bool isPlaying() const;
	virtual bool isRunning() const;

	virtual bool inPlaylist(string filename) const;
	virtual void cleanPlayed(int newsize);
	virtual void cleanQueued();
	virtual string getPath() const;
	virtual int getSongPosition() const;
	virtual void test();
private:
	CocoaScript* script() const;
	void setVars();
	vector<string> getQueued() const; //gets playlist for inPlaylist
	virtual string getRSongName() const;
	virtual int getRSongLength() const;
	virtual string getRFileName() const;
	CocoaScript* _scriptobj;	 
	QMutex* _scriptmutex;

	bool _playing;
	string _title;
	string _filename;
	int _length;
};

#endif
