#include "itunes.h"
#include "absutil.h"
#include "lpsettings.h"

#include <qfile.h>
#include <qtextstream.h>
#include <qmutex.h>
#import "cocoascript.h"

ITunes::ITunes() {
	//for now we only use an object for getsong
	_scriptobj = new CocoaScript(LPSettings::getResourceDir() + "scripts/getsong.applescript");
	_scriptmutex = new QMutex();
	_playing = false;
	_filename = "";
	_title = "";
	_length = 0;
	//test();
}

ITunes::~ITunes() {
	delete _scriptobj;
	delete _scriptmutex;
}

int ITunes::getPlaylistPosition() const {
	_scriptmutex->lock();
	string res = script()->executeScriptAt(LPSettings::getResourceDir() + "scripts/getposition.applescript");
	_scriptmutex->unlock();
	return atoi(res.substr(1,res.length()-1).c_str());
}

CocoaScript* ITunes::script() const {
	return _scriptobj;
}

void ITunes::play() {
	_scriptmutex->lock();
	script()->executeScriptNoResult("tell application \"iTunes\"\nplaypause\nend tell");
	_scriptmutex->unlock();
}

void ITunes::stop() {
	_scriptmutex->lock();
	script()->executeScriptNoResult("tell application \"iTunes\"\nstop\nend tell");
	_scriptmutex->unlock();
}

void ITunes::next() {
	_scriptmutex->lock();
	script()->executeScriptNoResult("tell application \"iTunes\"\nnext track\nend tell");
	_scriptmutex->unlock();
}

void ITunes::previous() {
	_scriptmutex->lock();
	script()->executeScriptNoResult("tell application \"iTunes\"\nprevious track\nend tell");
	_scriptmutex->unlock();
}

int ITunes::getVolume() {
	_scriptmutex->lock();
	string res = script()->executeScript("tell application \"iTunes\"\nset the result to \"b\" & the sound volume\nend tell");
	_scriptmutex->unlock();
	return atoi(res.substr(1,res.length()-1).c_str());
}

void ITunes::setVolume(int vol) {
	_scriptmutex->lock();
	script()->executeScriptNoResult(string("tell application \"iTunes\"\nset the sound volume to ") + absUtil::getUtil()->its(vol) + "\nend tell");
	_scriptmutex->unlock();
}

void ITunes::setVars() {
	_length = 0; _title = ""; _filename = ""; _playing = false;
	_scriptmutex->lock();
	string str = script()->execute();
	_scriptmutex->unlock();
	
	if (str.empty() || (str == "false")) return;
	_playing = true;

	uint pos = str.find("|_|",0);
	if (pos != string::npos) _filename = str.substr(0,pos);
	uint pos2 = str.find("|_|",pos+3);
	_title = str.substr(pos+3, pos2 - (pos+3)); 
	string duration = str.substr(pos2+3, str.length() - (pos2+3)); 
	_length = atoi(duration.c_str());
}

string ITunes::getPath() const { return ""; }

int ITunes::getPlaylistLength() const {
	_scriptmutex->lock();
	string res = script()->executeScriptAt(LPSettings::getResourceDir() + "scripts/gettrackcount.applescript");
	_scriptmutex->unlock();

	if (res.empty()) return 0;

	return atoi(res.substr(1,res.length()-1).c_str());
}

string ITunes::getRFileName() const {
	return _filename;
}

//only set when setVars is called
bool ITunes::isPlaying() const { return _playing; }
bool ITunes::isRunning() const { return 1; }

bool ITunes::inPlaylist(string filename) const {
	vector<string> playlist = getQueued();
	for (uint i=0;i<playlist.size();i++)
		if (playlist[i] == filename) return true;
	return false;
}

void ITunes::cleanPlayed(int /* newsize*/) {
	_scriptmutex->lock();
	script()->executeScriptAt(LPSettings::getResourceDir() + "scripts/cleanplayed.applescript");
	_scriptmutex->unlock();
}

void ITunes::cleanQueued() {
	_scriptmutex->lock();
	script()->executeScriptAt(LPSettings::getResourceDir() + "scripts/cleanqueued.applescript");
	_scriptmutex->unlock();
}

vector<string> ITunes::getQueued() const {
	_scriptmutex->lock();
	string str = script()->executeScriptAt(LPSettings::getResourceDir() + "scripts/getqueued.applescript");
	_scriptmutex->unlock();
	
	vector<string> files;
	if (str.empty() || (str == "false") || (str == "|_|")) return files;

	uint startpos = 3; //list starts with |_| so we start looking at 3
	bool atEnd = false;
	while (!atEnd) {
		uint pos = str.find("|_|",startpos); 
		if (pos != string::npos) {
			files.push_back(str.substr(startpos, pos - startpos));
		}
		else {
			atEnd = true;
			files.push_back(str.substr(startpos, str.length()-startpos));
		}
		startpos = pos + 3;
	}
	return files;
}

int ITunes::getSongPosition() const { return 1; }
int ITunes::getRSongLength() const { return _length; }

//this is quite dirty: getRSongName is the only method that calls setVars 
string ITunes::getRSongName() const {
	setVars();
	return _title;
}

void ITunes::play(vector<string> filenames) {
	_scriptmutex->lock();
	script()->executeScriptNoResult(
	"tell application \"iTunes\"\n"
	"delete (every track in playlist \"longplayer\")\n"
	"end tell"
	);
	_scriptmutex->unlock();

	queue(filenames);
	_scriptmutex->lock();
	script()->executeScriptNoResult(
	"tell application \"iTunes\"\n"
	"tell playlist \"longplayer\"\n"
	"play the first track\n"
	"end tell\n"
	"end tell"
	);
	_scriptmutex->unlock();

}

void ITunes::test() {
}

void ITunes::queue(vector<string> filenames) {	
	_scriptmutex->lock();
	script()->executeScriptAt(LPSettings::getResourceDir() + "scripts/checkplaylist.applescript");
	for (uint i=0;i<filenames.size();i++) {
			script()->executeScriptNoResult(
				"tell application \"iTunes\"\n"
				"set myf to \"" + filenames[i] + "\" as POSIX file\n"
				"add myf to playlist \"longplayer\"\n"
				"end tell"
			);
	}
	_scriptmutex->unlock();
}
