/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2003 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef logwah
#define logwah

#include "abslog.h"

class QFile;
class QTextStream;
class QApplication;
class QObject;
class QWidget;
class QProgressDialog;
class LPListener;
//TODO: remove this icky stuff
class LPWindowMainWA3;

/** Qt GUI implementation of absLog
 */
class LogWA : public absLog {
public:
	/** progress methods must be called in UI thread */
	virtual bool progressSet(int);
	virtual void progressInit(string text, int steps);
	virtual void progressEnd();

	/** constructs a logger... 
	 *  if debug, sends debugging messages to output object
	 */
	LogWA(bool debug);
 	virtual	~LogWA();

	void setLogFile(string filename);
	void setDebug(bool debug);

	/** sets required Qt output widget */
	void setWidget(QWidget* output);
	/** sets object to which all debugging and info messages will be sent (see LPGUIEvent) */
	void setOutput(QObject* output);
	void setApplication(QApplication* application);
	QApplication* getApplication();
	
	/** implemented functions from abslog.h */
	virtual void debug(int text);
	virtual void debug(string text);
	virtual void message(string text);
	virtual void info(string text, int displaylength=3000);
	virtual void error(string text);
	virtual void warning(string text);
	virtual void oops(string text);

	virtual void setListener(LPWindowMainWA3*);

private:
	QProgressDialog* _progress;
	//logfile
	QFile* _file;
	QTextStream* _stream;

	QObject* _output;
	QWidget* _widget;
	QApplication* _application;
	LPWindowMainWA3* _listener;
	bool _debug;
	
};

#endif
