/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_LPAPP
#define H_LPAPP  

#include "lpglobal.h"
#include "absutil.h"
#include "lpsong.h"
#include "lplistener.h"
#include "lpsettings.h"

#include <qthread.h>

#include <vector>

class absPlayer; class LPlayer; class LPDatabase; class LPSettings; class CompositePlaylist; class LPRemoteGeneric; class ThreadedCommand; 

class LPGUI : public LPListener {
	public:
	virtual void quit()=0;
};

 /* the managing application the gui communicates with
 */
class LPApp : public LPListener {

  public:
	static IntSetting SettingAutoQueue;
	static IntSetting SettingQueueOnStart;

	LPApp(LPSettings* );
	virtual ~LPApp();

	/** facade functions */

    /** play functions */	
	/** starts a mediaplayer and queues (causing the current song to stop) */
	void queue(bool now=true);
	void play(vector<string> files,bool force);

	absPlayer* getMPlayer() const;

	void setAutoQueue(bool b) ;
	bool getAutoQueue();

	/** finds in current playlist the filenames containing the pattern and queues /plays them */
	void search(string pattern,bool playnow);

	/** the playlist to use when running queue() or when auto-queueing */
	void changePlaylist(string name);
	string currentPlaylist();

	/** returns description of currently playing song */
	Song SongCurrent();

	/** playlists */
	
	/** returns all playlists in the system */
	vector<string> getPlaylists();
	CompositePlaylist* getPlaylist(string name);
	/** saves playlist so it can be returned later */
	void savePlaylist(CompositePlaylist* p);
	/** removes playlist from system */
	void removePlaylist(string p);

	/** settings */

	/** public for gui: it is allowed to remember some settings too */
	LPSettings* getSettings();

	/** stores song description in database */
	void SongStore(Song s);
	/** retrieves song description from database */
	Song SongRetrieveFromFilename(string filename);
	Song SongRetrieve(string key);

	/** Import/Export the database to an XML file */
	void DatabaseImportXML(string filename);
	void DatabaseExportXML(string filename);

	/** saves settings and preferences */
	void savePreferences();
	/** loads settings and preferences, all changes will be lost */
	void restorePreferences();

	/** function called by the real LPlayer  */
	void notify(int i=0);

	/** to subscribe to events */
	void subscribe(LPListener* lplayer);

	/** should be called by UI when it wants lplayer to quit gracefully */
	void quit();

	void applyGenreToDir(string dir, int x,int y, int z);
	void applyRatingToDir(string dir, int rating);

	LPlayer* getLPlayer();
	LPRemoteGeneric* getRemote();
	bool quitting(); 
  private:
	void DatabaseCheckCRCLinksImp();
	void checkFirstTime();

	void notifyListeners();
	vector<LPListener*> _listeners;

	bool _quitting;

	LPSettings* _settings;
	LPlayer* _lplayer;
	LPRemoteGeneric* _remote;

	/* commands */
	ThreadedCommand* getQueuer();
	ThreadedCommand* _queuer;
	vector<ThreadedCommand*> _commands;
};
#endif
