#include "../config.h"
#include "lpargparser.h"

#include <iostream>

LPArgParser::LPArgParser(int argc,char* argv[], LPSettings* settings) {
	_settings = settings;
	_valid = true;
	
	tokens = new QMap<string,int>; 
	nrArgs = new vector<int>;//nr of extra arguments each command line option needs
	settingnames = new vector<string>;
	int nrtokens=0; //nr of command line options

	(*tokens)["--play"]= nrtokens;
	nrArgs->push_back(0);
	settingnames->push_back("mainplay");
	nrtokens++;
	
	(*tokens)["--nogui"]=nrtokens;
	nrArgs->push_back(0);
	settingnames->push_back("mainnogui");
	nrtokens++;
	
	(*tokens)["--version"]=nrtokens;
	nrArgs->push_back(0);
	settingnames->push_back("mainversion");
	nrtokens++;

	(*tokens)["--test"]=nrtokens;
	nrArgs->push_back(0);
	settingnames->push_back("maintest");
	nrtokens++;

	(*tokens)["--help"]=nrtokens;
	nrArgs->push_back(0);
	settingnames->push_back("mainhelp");
	nrtokens++;

	(*tokens)["--settings"]=nrtokens;
	nrArgs->push_back(1);
	settingnames->push_back("settingslocation");
	nrtokens++;
	
	(*tokens)["--playlist"]=nrtokens;
	nrArgs->push_back(1);
	settingnames->push_back("lplayerplaylist");
	nrtokens++;

	(*tokens)["--debug"]=nrtokens;
	nrArgs->push_back(0);
	settingnames->push_back("maindebug");
	nrtokens++;

#ifdef _WS_WIN_
	(*tokens)["--trayonly"]=nrtokens;
	nrArgs->push_back(0);
	settingnames->push_back("mainstarttrayonly");
	nrtokens++;
#endif

	(*tokens)["--cleandb"]=nrtokens;
	nrArgs->push_back(1);
	settingnames->push_back("databaseclean");
	nrtokens++;

	for (int i=1;i<argc;i++) {
		//ps no use using logDebug here as it is not yet switched on

		//1 try to find the option in our list
		QMapIterator<string,int> it = (*tokens).find( string( (argv)[i] ) );
		if (it == (*tokens).end()) {
			_valid = false;
		}
		else {
			//2. check nr of arguments
			if ( (*nrArgs)[it.data()] ) {
				if (!string((argv)[++i]).find("--",0)) _valid = false; //option needs to start with "--" (find returns zero if found)
				else settings->setSetting((*settingnames)[it.data()],"",string((argv)[i]), false);
			}
			else { settings->setISetting((*settingnames)[it.data()],"",1,false); }
		}
	}

	//basic arguments (no lplayer needed for these)
	if (settings->testSetting("main","version")) {
		settings->setISetting("main","quit",1, false);
		cout << string(string("LongPlayer version ") + VERSION).c_str() << "\n";
	}

	if (settings->testSetting("main","help")) {
		settings->setISetting("main","quit",1, false);
		displayHelp();
	}
}

void LPArgParser::displayHelp() {
	cout << "LongPlayer supported command line arguments are:\n";
	cout << "--nogui                   starts text mode version (under construction)\n";
	#ifdef _WS_WIN_
	cout << "--trayonly                starts in tray only\n";
	#endif
	cout << "--play	                   immediately starts playback\n";
	cout << "--playlist playlistname   immediately starts playback\n";
	cout << "--settings settingsfile   uses alternate settings file\n";
	cout << "--cleandb playlistname    removes all database entries that are not present in the playlist\n";
	cout << "--version                 displays information about LongPlayer)\n";
	cout << "--help                    displays this text\n";
	cout << "--debug                   outputs heaps of debug information\n";
	#ifdef _WS_WIN_
	//wait before closing window
	cout << ("press enter to close this window.\n");
	getchar();
	#endif
}

bool LPArgParser::valid() { return _valid; }
