/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_LPDATABASE
#define H_LPDATABASE

#include <fstream>
#include <iostream>
#include <vector>

#include <qstring.h>
#include <qdatetime.h>
#include <qdom.h>
#include <qmap.h>

#include "absutil.h"
#include "lpsong.h"
#include "lpsettings.h"

using namespace std;

/** LPDatabase:
 *  class that is responsible for storing and retrieving all song descriptions that
 *  lplayer has encountered
 */
class LPSettings;
class QFile;
class LPDatabaseReader;
class Playlist;

class LPDatabase {
public:
	static StringSetting SettingLocation;
	static IntSetting SettingLastSize;
	static IntSetting SettingSaveOnExit;
	
	LPDatabase(LPSettings* settings);
	~LPDatabase();

	void flush();
	void compact();

	/** opens access to a database
	 */
	void load(string);

	/** import from an XML file */
	void importXML(string filename);
	/** exports to an XML file */
	void exportXMLTo(string filename);

	/** stores the given song description based on the key of the song
     *  if softmerge, won't replace filenames (e.g. when updating from another system) */
	void store(Song song,bool softmerge=false);
	void remove(Song song);
	/** looks up the song in the database  */
	Song retrieveAndCorrect(string filename, string name,int=0) ;

	/** looks up the song in the database */
	Song retrieve(string key);

	/** returns true when there is a song description in the database */
	bool inDatabase(string key) ;
	/** gives an estimate of the number of song descriptions in the database */
	int getSize() const;
	LPSettings* getSettings() const;
	LPDatabaseReader* getReader() const;
	void cleanDatabase(Playlist* playlistname);

private:
	void test();

	//database 
	string _filename;
	LPDatabaseReader* _reader;
	LPSettings* _settings;
};

#endif
