#include "absutil.h"
#include "lpdatabasereader.h"
#include "lpglobal.h"

Song LPDatabaseReader::retrieve(Song song)
{
    string origkey,workkey;
    origkey = song.getKey();
	workkey = origkey;

    Song dbsng = retrieve(workkey);
	dbsng.setKey(workkey); //in case it's empty/new
    //check if we have the right one (or none)
	if (dbsng.empty() || dbsng.equivalent(song)) return dbsng;

	//key clash: a song was retrieved with the same file key that is not equivalent..
    int i=0;
    while (i < 10)
    {
        i++;
        //this shouldn't happen often
        logDebug(string("LPDatabasePersistentReader::trying next entry in database (") + absUtil::its(i) + "th time) for song named " + song.getName() + ", last entry is named " + dbsng.getName());
        workkey = workkey + "A"; //a magic suffix :)
		song.setKey(workkey);
        dbsng = retrieve(workkey);
		dbsng.setKey(workkey); //in case it was empty
		if (dbsng.empty() || dbsng.equivalent(song)) return dbsng;
    }
    logWarning(string("LPDatabasePersistentReader::error while looking up ") + song.getName() + "/" + song.getFilename() + " vs " + dbsng.getName() + "/" + dbsng.getFilename() + ".");
   logOops(string("Error while looking up ") + song.getName() + "/" + song.getFilename() + " vs " + dbsng.getName() + "/" + dbsng.getFilename() + ". please report.");
	return Song();			
}


