/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_LPDBASEREADER
#define H_LPDBASEREADER

#include <string.h>

#include "lpsong.h"

using namespace std;

class LPDatabaseIterator;

/** 
 * LPDatabase:
 * class that is responsible for storing and retrieving all song 
 * descriptions that lplayer has encountered
 */
class LPDatabaseReader
{
public:
	virtual ~LPDatabaseReader(){};
	virtual void flush()=0; //quicksave?? ensures persistency
	virtual void compact()=0; //saves, compacts.. whatever

	/** stores the given song description based on the key of the song */
	virtual void store(Song song)=0;
	virtual void remove(Song song)=0;
	/** looks up the song in the database */
	virtual Song retrieve(string key)=0;
	/** looks up song, trying to avoid keyclash */
	/** returns song with correct key, be it empty */
	virtual Song retrieve(Song song);

	/** returns true when there is a song description in the database */
	virtual bool inDatabase(string key)=0;
	/** gives an estimate of the number of song descriptions in the database */
	virtual int getSize()=0;
    virtual LPDatabaseIterator* iterator()=0;
};

#endif
