#include "lpdatabasexmlreader.h"

/************************************************************
* Content Handler
*************************************************************/

LPDatabaseXMLReader::LPDatabaseXMLReader(LPDatabase* database){
	_database = database;

}

LPDatabaseXMLReader::~LPDatabaseXMLReader(){
}

bool LPDatabaseXMLReader::startDocument(){
	_song = Song();
	return true;
}

bool LPDatabaseXMLReader::startElement(const QString& , const QString& localName, const QString& , const QXmlAttributes&){
	if(localName == "song"){
		if(! _song.empty()){ //on the first element, it's empty
			_database->store(_song,true);
			//logDebug("Imported song:"+_song.getName()+":\n");
			_song = Song();
		}
	}
	_buffer = string("");
	return true;
}


bool LPDatabaseXMLReader::endElement(const QString& , const QString& localName, const QString& ){
	if(localName == "key"){
		_song.setKey(_buffer);
	}
	else{
		if(localName == "name"){
			_song.setName(_buffer);
		}
		else{
			if(localName == "filename"){
				_song.setFilename(_buffer);
			}
			else{
				if(localName == "date"){
					_song.setDate(atoi(_buffer.c_str()));
				}
				else{
					if(localName == "times"){
						_song.setTimes(atoi(_buffer.c_str()));
					}
					else{
						if(localName == "length"){
							_song.setLength(atoi(_buffer.c_str()));
						}
						else{
							if(localName == "score"){
							_song.setLike(atoi(_buffer.c_str())-5);
							}
						}
					}
				}
			}
		}
	}
	_buffer = string("");
	return true;
}


bool LPDatabaseXMLReader::characters(const QString& chars){
	_buffer += chars.local8Bit();
	return true;
}







/************************************************************
* Error Handler
*************************************************************/
LPDatabaseXMLReaderErrorHandler::LPDatabaseXMLReaderErrorHandler(){
	;
}

bool LPDatabaseXMLReaderErrorHandler::warning( const QXmlParseException & exception ){
		logWarning(string("LPDatabase:: importing XML. Warning:"+ string(exception.message().local8Bit())
		+" at line:"+
		absUtil::its(exception.lineNumber())+
		" column:"+ absUtil::its(exception.columnNumber())
		));
	return true;
}

bool LPDatabaseXMLReaderErrorHandler::error( const QXmlParseException & exception ){
	logError(string("LPDatabase:: importing XML. Error:"+ string(exception.message().local8Bit())
		+" at line:"+
		absUtil::its(exception.lineNumber())+
		" column:"+ absUtil::its(exception.columnNumber())
		));
	return true;
}

bool LPDatabaseXMLReaderErrorHandler::fatalError( const QXmlParseException & exception ){
	logOops(string("LPDatabase:: importing XML. FATAL ERROR:"+ string(exception.message().local8Bit())
		+" at line:"+
		absUtil::its(exception.lineNumber())+
		" column:"+ absUtil::its(exception.columnNumber())
		));
	return true;
}

/**
*  The reader calls this function to get an error string if any of the handler functions returns FALSE
*/
QString LPDatabaseXMLReaderErrorHandler::errorString(){
	return "LPDatabase:: importing XML. Impossible error occured. Universe will collapse in 5 seconds.";
}
