#include <qnamespace.h>

#include "lpfactory.h"
#include "logqt.h"
#include "absutil.h"
#include "lplayer.h"
#include "lpdatabase.h"
#include "playlistreader.h"
#include "absplayer.h"

LPFactory* LPFactory::_factory = 0;

LPSettings* LPFactory::getSettings() { return _settings; }

LPFactory* LPFactory::getFactory() {
	return _factory;
}

void LPFactory::setFactory(LPFactory* factory) {
	_factory  = factory;
}

LPFactory::LPFactory(LPSettings* settings) : _settings(settings), _lplayer(0) { }

LPlayer* LPFactory::getLPlayer() {
	if (!_lplayer) createLPlayer();
	return _lplayer;
}

//pre: settings, logger, util, player
void LPFactory::createLPlayer() {
	getSettings()->checkInit();

    _lplayer = new LPlayer(getSettings());

	//TODO move elsewhere
	if (getSettings()->testSetting("database","clean")) {
		logInfo("Cleaning database...");
		string playlist = getSettings()->getSetting("database","clean");
		LPDatabase db = LPDatabase(getSettings());
		Playlist* plist = getLPlayer()->getPlaylists()->getPlaylist(playlist);
		db.cleanDatabase(plist);
		delete plist;
		return;
	}
}

//pre: create!
void LPFactory::destroyLPlayer() {
	delete _lplayer;
	logDebug("cleaning up..");
}


