/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */

#ifndef LPFACTORY_H
#define LPFACTORY_H

#include "lpglobal.h"
#include "lpargparser.h"
#include "logqt.h"
#include "lplistener.h"

#include <qnamespace.h>

class LPSettings; class LPlayer;

/* LPFactory is responsible for creating and managing the lplayer instance
 * it needs a fully functional LPSettings, Logger, Util and absPlayer
 */
class LPFactory
{
	public:
		/* factory singleton */
		static LPFactory* getFactory();
		static void setFactory(LPFactory*);
		LPFactory(LPSettings* settings);
		
		//off
		void destroyLPlayer();	
		//returns an LPlayer (it may not have been initalized yet!)
		LPlayer* getLPlayer();

	private:
		//on
		void createLPlayer();

		LPSettings* _settings;
		LPSettings* getSettings();

		LPlayer* _lplayer;
		static LPFactory* _factory;
};
#endif
