#include <qlabel.h>

#include "lpformabout.h"
#include "lpsettings.h"
#include "lpdatabase.h"
#include "lplayer.h"
#include "lpapp.h"
#include "queuebuilder.h"

#include "../config.h"

/*
 *  Constructs a LPFormAboutBase which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
LPFormAbout::LPFormAbout(LPApp* app, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : LPFormAboutBase( parent, name, modal, fl )
{
	LPSettings* stats = app->getSettings();
	/*
	QString shape;
	shape = "Playlist is in normal shape.";
	if (stats->getISetting("heuristic","adaption") < -6) shape = "Playlist is still unexplored.";
	if (stats->getISetting("heuristic","adaption") > 6) shape = "Playlist is getting stale.";
	if (stats->getISetting("heuristic","adaption") > 12) shape = "Get some new songs, for the love of god!";
	*/
	TextLabel1->setText(
	QString(
		QString("LongPlayer ") + VERSION + " (2004-03-09)\n" +
		QString("Copyright (c) 2001-2004 by Andrew Wils\n\n") +
		QString("This program is free software: see the accompanying license file for details.\n\n\n") +
		QString("\nsongs in database: ") + absUtil::its(app->getLPlayer()->getDatabase()->getSize()).c_str() +
		QString("\nrandom songs delivered: ") +
		absUtil::its(stats->getISetting("stats","nrplayed")).c_str() +
//		QString("\nsongs rejected: ") +
//		absUtil::its(stats->getISetting("stats","nrrejected")).c_str() +
		QString("\naverage time between hearing a song twice: ") +
		absUtil::longTimeSpan((int)(stats->getSetting(QueueBuilder::SettingAverageInterval))).c_str()
		 /* 
		+ QString("\n")
		 + shape 
		 */
		)
		);
}

/*
 *  Destroys the object and frees any allocated resources
 */
LPFormAbout::~LPFormAbout()
{
    // no need to delete child widgets, Qt does it all for us
}
