#include "lpsettings.h"
#include "lpformplaylists.h"
#include "lpapp.h"
#include "lpglobal.h"
#include "lpdirview.h"

#include <qinputdialog.h>
#include <qlistbox.h>
#include <qdir.h>
#include <qlistview.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <qregexp.h>
#include <qstringlist.h>

#include "directoryplaylist.h"
#include "m3uplaylist.h"
#include "compositeplaylist.h"

LPFormPlaylists::LPFormPlaylists(LPApp* app, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : LPFormPlaylistsBase( parent, name, modal, fl ), _app(app), _playlist(0)
{
	refreshPlaylists();
}

LPApp* LPFormPlaylists::getApp() { return _app; }

void LPFormPlaylists::checkButtons() {
	btnPlaylistAddDir->setEnabled(boxPlaylist->count());
	btnAddM3U->setEnabled(boxPlaylist->count());
	btnPlaylistToggleSubDirs->setEnabled(viewPlaylistDirs->currentItem() && viewPlaylistDirs->currentItem()->text(1));
	btnPlaylistRemoveDir->setEnabled(viewPlaylistDirs->currentItem());
}

void LPFormPlaylists::apply() {
	PlaylistSave();
	getApp()->savePreferences();
}

void LPFormPlaylists::accept() {
	LPFormPlaylistsBase::accept();
	apply();
}

void LPFormPlaylists::reject() {
	LPFormPlaylistsBase::reject();
	getApp()->restorePreferences();
}

void LPFormPlaylists::PlaylistAddM3U() {
  QString lastdir = QString::fromLocal8Bit(getApp()->getSettings()->getSetting("playlistactions", "lastdir").c_str());
    QString s( QFileDialog::getOpenFileName( lastdir,"M3U Files (*.m3u);;All Files (*.*)", this,"Stuff", "Select an m3u") );     if ( s.isEmpty() )        return;
    getApp()->getSettings()->setSetting("playlistactions","lastdir",string(QFileInfo(s).dirPath().local8Bit()));
    M3UPlaylist* p = new M3UPlaylist(string(s.local8Bit()));
	p->setM3U(string(s.local8Bit()));
	_playlist->addPlaylist(p);
    new QListViewItem( viewPlaylistDirs, s, "" );
}

void LPFormPlaylists::PlaylistAddDir() {
//	LPDirView* view = new LPDirView();
	QString lastdir = QString::fromLocal8Bit(getApp()->getSettings()->getSetting("playlistactions", "lastdir").c_str());
	QString s( QFileDialog::getExistingDirectory( lastdir, this,"Stuff", "Select a directory containing music", false) );
    if ( s.isEmpty() )
        return;
	QDir dir(s); dir.cdUp();
	getApp()->getSettings()->setSetting("playlistactions","lastdir",string(dir.absPath().local8Bit()));
	DirectoryPlaylist* p = (DirectoryPlaylist*)_playlist->getPlaylists()[0];
	p->addDir(string(s.local8Bit()),true);
	new QListViewItem( viewPlaylistDirs, s, "true" );
}

void LPFormPlaylists::refreshPlaylists() {
	boxPlaylist->clear();
	vector<string> playlists = getApp()->getPlaylists();
	string currplaylist = getApp()->currentPlaylist();
    QStringList list;
	for (uint i=0;i<playlists.size();i++) {
        list << QString::fromLocal8Bit(playlists[i].c_str());
	}
    list.sort();
	int index= 0;
	for (uint j=0;!index && (j<list.count());j++) {
		if (list[j] == QString::fromLocal8Bit(currplaylist.c_str())) index = j;
	}
	boxPlaylist->insertStringList(list);
	boxPlaylist->setCurrentItem(index);
	if (!boxPlaylist->count()) { viewPlaylistDirs->clear(); }
	PlaylistSelect();
	checkButtons();
}

void LPFormPlaylists::PlaylistCreate() {
	bool ok;
 	QString text = QInputDialog::getText( tr( "New Playlist" ), tr( "Please enter the name of a new playlist. Make sure it does not contain any special characters." ), QLineEdit::Normal, "new_playlist", &ok, this );
  	if ( ok && !text.isEmpty() ) {
		 // user entered something and pressed ok
		  //todoLOW: playlist already exists
		if (_playlist) {
			PlaylistSave();
			delete _playlist;
		}
		_playlist = new CompositePlaylist(string(text.local8Bit()));
		_playlist->addPlaylist(new DirectoryPlaylist());
		boxPlaylist->insertItem(text);
		boxPlaylist->setCurrentItem(boxPlaylist->count()-1);
		viewPlaylistDirs->clear();
	}
	else {} // user entered nothing or pressed cancel
	checkButtons();
}

void LPFormPlaylists::PlaylistSave() {
	vector<string> filenamesEnd = vector<string>();
    QStringList splitted = QStringList::split ( ";", edtMasks->text(), FALSE );
	logDebug(string("adding ") + edtMasks->text().latin1()	);
    string mask; QString qmask;
    for (uint i=0;i<splitted.count();i++) {
        QRegExp num("[*. ]*");
        qmask = splitted[i].replace(num,"");//first bring into a QString to avoid a Windows crash
        if (!qmask.isEmpty()) mask = string(qmask.local8Bit()); else mask = "";
        if (mask != "") filenamesEnd.push_back(mask);
    }
	_playlist->setFilenamesEndWith(filenamesEnd);

	vector<string> filenamesDoNotEnd = vector<string>();
    splitted = QStringList::split ( ";", edtExcludeMasks->text(), FALSE );
    mask = "";
    for (uint j=0;j<splitted.count();j++) {
        QRegExp num("[*. ]*");
        qmask = splitted[j].replace(num,"");//first bring into a QString to avoid a Windows crash
		if (!qmask.isEmpty()) mask = string(qmask.local8Bit()); else mask = "";        if (mask != "") filenamesDoNotEnd.push_back(mask);
	}
	_playlist->setFilenamesDoNotEndWith(filenamesDoNotEnd);

	getApp()->savePlaylist(_playlist);
}

void LPFormPlaylists::PlaylistSaveAs() {
	bool ok;
	QString text = QInputDialog::getText( tr( "New Playlist" ), tr( "Please enter the name of a new playlist. Make sure it does not contain any spaces or special characters." ), QLineEdit::Normal, "new_playlist", &ok, this );
	string oldname = _playlist->getName();;
 	if ( ok && !text.isEmpty() ) {
		// user entered something and pressed ok
		//todoLOW: playlist already exists
		_playlist->setName(string(text.local8Bit()));
		boxPlaylist->insertItem(text);
		PlaylistSave();
		_playlist->setName(oldname);
		checkButtons();
	}
}

void LPFormPlaylists::PlaylistSelectDir() { checkButtons(); }

void LPFormPlaylists::PlaylistRemoveDir() {
	//check if dir or m3u
	if (viewPlaylistDirs->currentItem()->text(1) == "")
		_playlist->removePlaylist(string(viewPlaylistDirs->currentItem()->text(0).local8Bit()));
	else
		((DirectoryPlaylist*)_playlist->getPlaylists()[0])->removeDir(string(viewPlaylistDirs->currentItem()->text(0).local8Bit()));
	delete viewPlaylistDirs->currentItem();
	checkButtons();
}

void LPFormPlaylists::PlaylistToggleSubDirs() {
	if (viewPlaylistDirs->currentItem()) {
		QString s = viewPlaylistDirs->currentItem()->text(1);
		if (s == "true") viewPlaylistDirs->currentItem()->setText(1,"false");
		if (s == "false") viewPlaylistDirs->currentItem()->setText(1,"true");

		((DirectoryPlaylist*)_playlist->getPlaylists()[0])->clearDirs();
		QListViewItem* ch = viewPlaylistDirs->firstChild();
		for (int i=0;i<viewPlaylistDirs->childCount();i++) {
			((DirectoryPlaylist*)_playlist->getPlaylists()[0])->addDir(
				string(ch->text(0).local8Bit()),
				(ch->text(1) == "true") ? 1:0
			);
			ch = ch->nextSibling();
		}
	}
}

void LPFormPlaylists::PlaylistRemove() {
	if (!_playlist) return;
	logDebug(string("GUI::removing ") + _playlist->getName());
	getApp()->removePlaylist(_playlist->getName());
	delete _playlist; _playlist = 0;
	refreshPlaylists();
}

void LPFormPlaylists::PlaylistSelect() {
	if (_playlist) PlaylistSave();
	QString s = boxPlaylist->currentText();
	if (s) {
		logDebug(string("GUI::drawing playlist ") + string(s.latin1()));

		if (_playlist) delete _playlist;
		_playlist = getApp()->getPlaylist(string(s.local8Bit()));

		//dirs
		DirectoryPlaylist* dirp = ((DirectoryPlaylist*)_playlist->getPlaylists()[0]);
		vector<string> dirs = dirp->getDirs();
		vector<bool> incldirs = dirp->getIncludeSubDirs();
		viewPlaylistDirs->clear();
		for (uint j=0;j<dirs.size();j++) {
			new QListViewItem( viewPlaylistDirs, QString::fromLocal8Bit(dirs[j].c_str()), (incldirs[j]) ? "true":"false" );
		}
		//with m3us
		for (uint m=1;m<_playlist->getPlaylists().size();m++) {
			new QListViewItem( viewPlaylistDirs,
				QString::fromLocal8Bit(
					((M3UPlaylist*)(_playlist->getPlaylists()[m]))->getM3U().c_str()
				), "");
		}

		string mask;
 		vector<string> filenamesEnd = _playlist->getFilenamesEndWith();
		for (uint i=0;i<filenamesEnd.size();i++) {
			mask = mask +  string("*.") + filenamesEnd[i];
			if (i != filenamesEnd.size()-1) mask = mask + ";";
		}
		logDebug(string("GUI::drawing inc mask  ") + mask );
		if (mask == "") mask = "*.*";
		edtMasks->setText(mask.c_str());

		string emask;
 		vector<string> filenamesDoNotEnd = _playlist->getFilenamesDoNotEndWith();
		for (uint k=0;k<filenamesDoNotEnd.size();k++) {
			emask = emask +  string("*.") + filenamesDoNotEnd[k];
			if (k != filenamesDoNotEnd.size()-1) emask = emask + ";";
		}
		logDebug(string("GUI::drawing exc mask ") + emask);
		edtExcludeMasks->setText(emask.c_str());

		btnPlaylistAddDir->setEnabled(true);
		btnPlaylistToggleSubDirs->setEnabled(false);
		btnPlaylistRemoveDir->setEnabled(false);
	}
}
