#include "lpsettings.h"
#include "lpformprefs.h"
#include "lpapp.h"
#include "lpglobal.h"
#include "lpwindowmain.h"
#include "lplayer.h"
#include "absplayer.h"
#include "autoqueue.h"
#include "queuebuilder.h"

#include <qspinbox.h>
#include <qinputdialog.h> 
#include <qlistbox.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <qcheckbox.h>
#include <qslider.h>
#include <qlabel.h>

LPApp* LPFormPrefs::getApp() { return _app; }

LPFormPrefs::LPFormPrefs(LPApp* app, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : LPFormPrefsBase( parent, name, modal, fl ), _app(app)
{
	LPSettings* s = getApp()->getSettings();
	//read settings
	chkTrim->setChecked(s->getSetting(absPlayer::getPlayer()->SettingPlaylistTrim));
	spinTrim->setValue(s->getSetting(absPlayer::getPlayer()->SettingPlaylistTrimVal));
	chkLPTrim->setChecked(s->getSetting(LPWindowMain::SettingTrim));
	spinLPTrim->setValue(s->getSetting(LPWindowMain::SettingTrimVal));
	spinQueueAheadMax->setValue(s->getSetting(AutoQueue::SettingAmount));
	spinQueueDJSong->setValue(s->getSetting(QueueBuilder::SettingDJEvery));
	chkQueueDJSong->setChecked(s->getSetting(QueueBuilder::SettingDJMode));
	SetDJSong(s->getSetting(QueueBuilder::SettingDJMode));
	sldEffort->setValue(getApp()->getSettings()->getSetting(LPlayer::SettingEffort));
	txtQueueDJSong->setText(QString::fromLocal8Bit(s->getSetting(QueueBuilder::SettingDJSong).c_str()));

	chkSplash->setChecked(s->getSetting(LPWindowMain::SettingSplash));
	chkQueueOnStart->setChecked(getApp()->getSettings()->getSetting(LPApp::SettingQueueOnStart));

#ifdef _WS_WIN_
	if (getApp()->getSettings()->getSetting(LPWindowMain::SettingTray)) {
		chkHide->setEnabled(true);
		chkHideOnClose->setEnabled(true);
	}
	else {
		chkHide->setEnabled(false);
		chkHideOnClose->setEnabled(false);
		getApp()->getSettings()->setSetting(LPWindowMain::SettingHideOnMinimize, false);
		getApp()->getSettings()->setSetting(LPWindowMain::SettingHideOnClose, false);
	}
	chkTray->setChecked(getApp()->getSettings()->getSetting(LPWindowMain::SettingTray));
	chkHide->setChecked(getApp()->getSettings()->getSetting(LPWindowMain::SettingHideOnMinimize));
	chkHideOnClose->setChecked(getApp()->getSettings()->getSetting(LPWindowMain::SettingHideOnClose));
	chkHideOnClose->hide();//TODO implement this setting..
#else
	txtTray->hide();
	chkTray->hide();
	chkHide->hide();
	chkHideOnClose->hide();
#endif

	sldRatingWeight->setValue(getApp()->getSettings()->getISetting("heuristic","ratingweight"));
	sldLengthWeight->setValue(getApp()->getSettings()->getISetting("heuristic","lengthweight"));
}

void LPFormPrefs::checkButtons() { }

void LPFormPrefs::accept() {
	LPFormPrefsBase::accept();
	LPSettings* s = getApp()->getSettings();

	s->setISetting("heuristic","lengthweight",sldLengthWeight->value());
	s->setISetting("heuristic","ratingweight",sldRatingWeight->value());

	s->setSetting(absPlayer::SettingPlaylistTrim,chkTrim->isChecked());
	s->setSetting(absPlayer::SettingPlaylistTrimVal, spinTrim->value());
	s->setSetting(LPWindowMain::SettingTrim,chkLPTrim->isChecked());
	s->setSetting(LPWindowMain::SettingTrimVal,spinLPTrim->value());

	s->setSetting(LPWindowMain::SettingSplash,chkSplash->isChecked());

	s->setSetting(AutoQueue::SettingAmount,spinQueueAheadMax->value());
	s->setSetting(LPlayer::SettingEffort,sldEffort->value());
	s->setSetting(QueueBuilder::SettingDJMode,chkQueueDJSong->isChecked());
	s->setSetting(QueueBuilder::SettingDJEvery,spinQueueDJSong->value());
	if (txtQueueDJSong->text().length()) //qtwin2 check
	s->setSetting(QueueBuilder::SettingDJSong,string(txtQueueDJSong->text().local8Bit()));

	getApp()->savePreferences();
}

void LPFormPrefs::reject() {
	LPFormPrefsBase::reject();
	getApp()->restorePreferences();
}

void LPFormPrefs::SetTrim(int /*i*/) { }
void LPFormPrefs::SetLPTrim(int /*i*/) { }

void LPFormPrefs::SelectDJSong() {
	QString lastdir = QString::fromLocal8Bit(getApp()->getSettings()->getSetting("fileactions","lastdir").c_str());
	QString s = QFileDialog::getOpenFileName( lastdir, "All files ( * )", this, 0 , "Choose filename to play");

	if ( s.isEmpty() ) return;

	getApp()->getSettings()->setSetting("fileactions","lastdir",string(QFileInfo(s).dirPath().local8Bit()));
	txtQueueDJSong->setText(s);
}

void LPFormPrefs::SetDJSong(int i) {
	btnQueueDJSong->setEnabled(i);
	spinQueueDJSong->setEnabled(i);
}

void LPFormPrefs::SetHide(int i) { getApp()->getSettings()->setSetting(LPWindowMain::SettingHideOnMinimize,i); }
void LPFormPrefs::SetHideOnClose(int i) { getApp()->getSettings()->setSetting(LPWindowMain::SettingHideOnClose,i); }

void LPFormPrefs::SetTray(int i) {
	getApp()->getSettings()->setSetting(LPWindowMain::SettingTray,i);
	if (i) {
		chkHide->setEnabled(true);
		chkHideOnClose->setEnabled(true);
	}
	else {
		chkHide->setEnabled(false);
		chkHideOnClose->setEnabled(false);
		chkHide->setChecked(false);
		chkHideOnClose->setChecked(false);
		getApp()->getSettings()->setSetting(LPWindowMain::SettingHideOnMinimize, false);
		getApp()->getSettings()->setSetting(LPWindowMain::SettingHideOnClose, false);
	}
}

void LPFormPrefs::SetSplash(int /*i*/) { }

void LPFormPrefs::SetQueueOnStart(int i) {
	logDebug(absUtil::its(i));
	getApp()->getSettings()->setSetting(LPApp::SettingQueueOnStart,i);
}
