#include "lpformsearch.h"

#include "lpsettings.h"
#include "lplayer.h"
#include "lpapp.h"
#include "lpsongfilter.h"
#include "lpglobal.h"
#include "lpguihandler.h"
#include "lpplaylistiterator.h"
#include "playlist.h"
#include "compositeplaylist.h"
#include "lpdatabase.h"
#include "buildplaylist.h"
#include "threadedcommand.h"
#include "genrewidget.h"

#include <qapplication.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qfiledialog.h>
#include <qprogressdialog.h>
#include <qfileinfo.h>
#include <qmessagebox.h>
#include <qlayout.h>

#include <fstream>

LPFormSearch::LPFormSearch(LPApp* app, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : LPFormSearchBase( parent, name, modal, fl ), _lastItem(0), _app(app), _listp(0), _filter(0), _iterator(0), _builder(0), currSongs(0), currMB(0)
{
	_genreWidget = new GenreConstraintWidget((QWidget*)grpSearch_2,"genrewidget");
	_genreWidget->setProperty( "frameShape", (int)QFrame::StyledPanel );
	_genreWidget->setProperty( "frameShadow", (int)QFrame::Sunken );
	_genreWidget->setLineWidth(2);
	_genreWidget->setMessage("draw a rectangle\n to constrain");
	grpSearch_2Layout->addWidget(_genreWidget);
    //connect(_genreWidget,SIGNAL(constraintChanged(int, int, int,int)),this,SLOT(setQConstraint(int, int, int,int)));

	txtStatus->setText("");
	cmbRating->insertItem("equals");
	cmbRating->insertItem("less than");
	cmbRating->insertItem("more than");
	cmbTimes->insertItem("equals");
	cmbTimes->insertItem("less than");
	cmbTimes->insertItem("more than");
	cmbHeard->insertItem("less than");
	cmbHeard->insertItem("more than");

	cmbStopCondition->insertItem("songs");
	cmbStopCondition->insertItem("megabytes");
	spinStopCondition->setMaxValue(10000);
	
	cmbHeard2->insertItem("hours");
	cmbHeard2->insertItem("days");
	cmbHeard2->insertItem("weeks");
	viewSearched->setMultiSelection(true);

	checkButtons();
	refreshPlaylists();
}

LPFormSearch::~LPFormSearch() {
	if (_listp) delete _listp; _listp = 0;
}

void LPFormSearch::refreshPlaylists()
{	
    cmbPlaylist->clear();
	vector<string> playlists = getApp()->getPlaylists();
	string currplaylist = getApp()->currentPlaylist();
    QStringList list;
	for (uint i=0;i<playlists.size();i++) {
        list << playlists[i].c_str();
	}
    list.sort();
	int index= 0;
	for (uint j=0;!index && (j<list.count());j++) {
		if (list[j] == currplaylist.c_str()) index = j;
	}
	cmbPlaylist->insertStringList(list);
	cmbPlaylist->setCurrentItem(index);
}

void LPFormSearch::random(){ checkButtons();}
void LPFormSearch::rating(){ checkButtons();}
void LPFormSearch::times(){ checkButtons();}
void LPFormSearch::heard(){ checkButtons();}

void LPFormSearch::checkButtons() {
	btnSearch->setEnabled(true);
	btnCancelSearch->setEnabled(false);
	cmbRating->setEnabled(chkRating->isChecked());
	spinRating->setEnabled(chkRating->isChecked());
	cmbHeard->setEnabled(chkHeard->isChecked());
	cmbHeard2->setEnabled(chkHeard->isChecked());
	spinHeard->setEnabled(chkHeard->isChecked());
	cmbTimes->setEnabled(chkTimes->isChecked());
	spinTimes->setEnabled(chkTimes->isChecked());
	spinStopCondition->setEnabled(chkRandom->isChecked());
	cmbStopCondition->setEnabled(chkRandom->isChecked());
}

void LPFormSearch::accept() {
	if (btnCancelSearch->isEnabled()) cancelSearch();
	LPFormSearchBase::accept();
}

void LPFormSearch::reject() {
	if (btnCancelSearch->isEnabled()) cancelSearch();
	LPFormSearchBase::reject();
}

LPApp* LPFormSearch::getApp() { return _app; }

void LPFormSearch::playSong(QListViewItem* item) {
    Song s = getApp()->SongRetrieve(item->text(songkeycolid).latin1());
    if (s.getFilename().empty()) return;
	vector<string> files; files.push_back(s.getFilename());
	getApp()->play(files,true);
}

vector<string> LPFormSearch::getFoundSongs() {
	QListViewItem* current;
	vector<string> files;
	current = viewSearched->firstChild();
	while (current) {
		if (current->isSelected()) {
			files.push_back(string(current->text(fullpathcolid).local8Bit()));
		}
		current = current->nextSibling();
	}
	if (!files.size()) {
		//nothing selected
		current = viewSearched->firstChild();
		while (current) {
			files.push_back(string(current->text(fullpathcolid).local8Bit()));
			current = current->nextSibling();
		}
	}
	return files;
}

void LPFormSearch::playSongs() { getApp()->play(getFoundSongs(),true); }

void LPFormSearch::saveM3U() {
	vector<string> files = getFoundSongs();
	if (!files.size()) return;
	
	QString lastdir = QString::fromLocal8Bit(getApp()->getSettings()->getSetting("searchactions","lastdir").c_str());
   	QString s( QFileDialog::getSaveFileName( lastdir,"M3U Files (*.m3u);;All Files (*.*)", this,"create m3u file...", "Select a file") );
    if ( s.isEmpty() )
        return;
	getApp()->getSettings()->setSetting("searchactions","lastdir",string(QFileInfo(s).dirPath().local8Bit()));

    ofstream ofile( s.local8Bit() );

	for (uint i=0; i<files.size();i++) {
		ofile << files[i].c_str() << "\n";
	}
    ofile.close();
}

void LPFormSearch::copySongs() {
	vector<string> files = getFoundSongs();
	if (!files.size()) return;

	QString lastdir = QString::fromLocal8Bit(getApp()->getSettings()->getSetting("searchactions","lastdir").c_str());
    QString s( QFileDialog::getExistingDirectory( lastdir, this,"Copy songs to...", "Select a directory to copy the music to", true) );
    if ( s.isEmpty() )
        return;
	getApp()->getSettings()->setSetting("searchactions","lastdir",string(QFileInfo(s).dirPath().local8Bit()));

	QProgressDialog progress( "Copying files...", "Abort Copy", files.size(),
                          this, "progress", TRUE );
	for (uint i=0; i<files.size();i++) {
    	progress.setProgress(i);
    	qApp->processEvents();
    	if ( progress.wasCancelled() ) break;
		QString from = QString::fromLocal8Bit(files[i].c_str());
		QString dest = s + "/" + QFileInfo(from).fileName();
		absUtil::getUtil()->copyFile(files[i],string(dest.local8Bit()));
	}
	progress.setProgress(files.size());
}

void LPFormSearch::deleteSongs() {
	vector<string> files = getFoundSongs();
	if (!files.size()) return;

	QListViewItem* current = viewSearched->firstChild();
	QListViewItem* toDelete;
	bool deleteAll = (files.size() == (uint) viewSearched->childCount()); //only delete the selected or everything? 

	switch( QMessageBox::information( this, "LongPlayer",
        "This will physically erase the songs from disk.\n"
        "Are you sure you want do that?",
        "Delete","Cancel", 0,
        1,      // Enter == button 1
        1 ) ) 
	{ 
		case 0: 
			while (current) {
				if (current->isSelected() || deleteAll) {
					absUtil::getUtil()->removeFile(string(current->text(fullpathcolid).local8Bit()),true);
					toDelete = current;
					current = current->nextSibling();
					delete toDelete;
				}
				else 
					current = current->nextSibling();
			}
			break;
		case 1: 
			break;
	}
}

void LPFormSearch::queueSongs() { getApp()->play(getFoundSongs(),false); }

int LPFormSearch::getFilterType(QString text) {
	if (text == "more than") return LPSongFilter::MORE;
	if (text == "less than") return LPSongFilter::LESS;
	if (text == "equals") return LPSongFilter::EQUAL;
	logWarning(string("LPFormSearch::invalid filter: ") + text.latin1());
	return 0;
}

void LPFormSearch::startSearch() {
	txtStatus->setText("Building playlist...");
	btnSearch->setEnabled(false);
	btnCancelSearch->setEnabled(true);
	viewSearched->clear();
	//speedup
	viewSearched->setSorting(-1);

	currSongs = 0; stopSongs = 0; currMB = 0; stopMB = 0; 

	_filter = new LPDummyFilter();
	LPSongFilter* filter1,*filter2;
	if (chkTimes->isChecked()) {
		filter2 = _filter;
    	filter1 = new LPTimesFilter(getFilterType(cmbTimes->currentText()), spinTimes->value());
		_filter = new LPAndFilter(filter1,filter2);		
	}
	if (chkRating->isChecked()) {
		filter2 = _filter;
    	filter1 = new LPRatingFilter(getFilterType(cmbRating->currentText()), spinRating->value() - 5,true);
		_filter = new LPAndFilter(filter1,filter2);		
	}
	if (chkHeard->isChecked()) {
		int seconds=spinHeard->value();
		if (cmbHeard2->currentText()=="days")
			seconds *= 3600*24;
		if (cmbHeard2->currentText()=="weeks")
			seconds *= 3600*24*7;
		if (cmbHeard2->currentText()=="hours")
			seconds *= 3600;
		filter2 = _filter;
    	filter1 = new LPSecondsAgoFilter(getFilterType(cmbHeard->currentText()), seconds);
		_filter = new LPAndFilter(filter1,filter2);		
	}
	int x1, x2, y1, y2;
	_genreWidget->getConstraint(&x1, &y1, &x2, &y2);
	if ((x1 - x2) || (y1 - y2)) { 
		filter2 = _filter;
		filter1 = new LPColorFilter2(x1, y1, x2, y2);
		_filter = new LPAndFilter(filter1, filter2);
	}
	if (chkRandom->isChecked()) {
		if (cmbStopCondition->currentText() == "songs") { stopSongs = spinStopCondition->value(); }
		if (cmbStopCondition->currentText() == "megabytes") { stopMB = spinStopCondition->value(); }
	}

	//start building of playlist
	Playlist* tpl = getApp()->getPlaylist(string(cmbPlaylist->currentText().local8Bit()));
	if (!_listp) _listp = tpl;
	if (_listp->getName() != tpl->getName()) { delete _listp; _listp = tpl; } //only change when it differs (to avoid rebuilding)

	if (!_listp->getBuilt()) _builder = new ThreadedCommand(new BuildPlaylist(_listp));

	Playlist& list = *_listp;
	if (txtFilename->text().length()) { 
		vector<string> contains = list.getFilenamesContain();
		contains.push_back(string(txtFilename->text().local8Bit()));
		list.setFilenamesContain(contains);
	}
	if (_builder) {
		((BuildPlaylist*)_builder->getCommand())->setDone(false); //to avoid race condition when checkbuilt checks done before set in start
		_builder->start();
	}
	timerMutex.lock();
	_timer = new QTimer(this);
    connect( _timer, SIGNAL(timeout()), SLOT(checkBuilt()) );
    _timer->start( 0, FALSE );
	timerMutex.unlock();
}

void LPFormSearch::cancelSearch() {
	timerMutex.lock();
	if (_timer) {
		_timer->stop();			
		delete _timer;
		_timer = 0;
	}
	timerMutex.unlock();
	if (_builder) { 
		_builder->getCommand()->stop();
		logDebug("UI::waiting for builder to finish..");
		while (!_builder->getCommand()->done()) 
			_builder->wait(100);
		delete _builder; _builder = 0;
	}
	searchStep.lock();
	if (_iterator) delete _iterator; _iterator = 0;
	searchStep.unlock();
	if (_filter) delete _filter; _filter = 0;
		QString strSongs = currSongs == 1 ? " song " : " songs ";
		txtStatus->setText(
			QString("Found ") + QString(absUtil::its(currSongs).c_str()) + strSongs + 
			"(" + QString(absUtil::its(currMB).c_str() ) + "MB).");
	btnSearch->setEnabled(true);
	btnCancelSearch->setEnabled(false);
	//allow user to sort
	viewSearched->setSorting (100);
	logDebug("UI::search cancelled.");
}

void LPFormSearch::checkBuilt() {
	//todo mutex needed?
	if (_builder && !_builder->getCommand()->done()) return;
	timerMutex.lock();
		if (_timer) _timer->stop();
	timerMutex.unlock();

	txtStatus->setText("Searching...");
    _iterator = new LPPlaylistIterator(_listp,_filter ,getApp()->getLPlayer()->getDatabase(),chkRandom->isChecked(),false );

	timerMutex.lock();
		if (_timer) {
		delete _timer;
		_timer = new QTimer( this );
		connect( _timer, SIGNAL( timeout() ), SLOT( searchOneSong() ) );
		_timer->start( 0, FALSE );
		}
	timerMutex.unlock();

}

void LPFormSearch::notify(int /*i*/) {
	//checkbuilt will check everything
}

void LPFormSearch::searchOneSong() {
	searchStep.lock();
    Song s;
    if (_iterator && _iterator->hasNext()) {
		s = _iterator->next();
		txtStatus->setText(QString("Searching (") + QString(absUtil::its((_iterator->getPosition()*100)/_iterator->getSize()).c_str()) + "%)");
		searchStep.unlock();
		if (!s.getFilename().empty()) {
			makeSongListViewItem(viewSearched,s);
			if (s.size()) currMB += (s.size() >> 20); 
			currSongs++;
			if (stopMB && (currMB >= stopMB)) {
			cancelSearch(); 
			}
			if (stopSongs && (currSongs >= stopSongs)) {
			cancelSearch(); 
			}
		}
	}
	else {
		searchStep.unlock();
		cancelSearch();
	}
}

bool LPFormSearch::event(QEvent* e) {
    if (e->type() ==  QEvent::User ) {
        if (LPGUIEvent *lpe = (LPGUIEvent*)(e) ) {
            int type = lpe->getType();
            switch (type) {
            case LPGUIEvent::LPDEBUG:
                break;
            case LPGUIEvent::LPINFO:
            //    statusbar->message(lpe->getMessage(),3000);
                break;
            case LPGUIEvent::LPWARNING:
             //   statusbar->message(lpe->getMessage(),7500);
                break;
            case LPGUIEvent::LPMESSAGE:
                QMessageBox::information( this, "LongPlayer",
                              lpe->getMessage().c_str());
                break;
            case LPGUIEvent::LPERROR:
            //    statusbar->message(lpe->getMessage(),10000);
                QMessageBox::critical( this, "LongPlayer",
                              lpe->getMessage().c_str());
                break;
			}
			return true;
		}
	}
	return LPFormSearchBase::event(e);
}

void LPFormSearch::makeSongListViewItem(QListView* list, Song sng,QListViewItem* vitem) {
    if (!vitem) {
		if (_lastItem) _lastItem = new SearchedSongItem(list,sng, _lastItem);
		else _lastItem = new SearchedSongItem(list,sng);
		fullpathcolid = 6;
		songkeycolid = 5;
    }
    else { ((SearchedSongItem*)vitem)->setSong(sng); }
}

SearchedSongItem::SearchedSongItem(QListView* list, Song sng) : QListViewItem(list) {
	    setSong(sng);
}
SearchedSongItem::SearchedSongItem(QListView* list, Song sng, QListViewItem* after) : QListViewItem(list,after) {
	    setSong(sng);
}

void SearchedSongItem::setSong(Song sng) {
    QString name, like, heard, times, length; int date;
    name = sng.getName().c_str();

    if (!sng.heard()) {
        heard = "no";
        times = "never";
    }
    else {
       date = sng.getOldDate();//TODO change in Date
       if (!date) { date = sng.getDate(); }
       if (!date) { heard = "never"; }
       else {
	       heard = string(absUtil::longTimeSpan(absUtil::getUtil()->date() - date) + " ago").c_str();
       }
       times = absUtil::its(sng.getTimes()).c_str();
    }
    if (sng.getLike()) like = string(absUtil::its(sng.getLike() + 5) + "/10").c_str();
    else like = "neutral";
    if (sng.length() > 0) length = absUtil::shortTimeSpan(sng.length()).c_str();
        else length = "unknown";

    int i = 0;
    QFileInfo fileInfo(QString::fromLocal8Bit(sng.getFilename().c_str()));
    QListViewItem::setText(i++,fileInfo.fileName());//0
    QListViewItem::setText(i++,fileInfo.dirPath());//1
    QListViewItem::setText(i++,heard);//2
    QListViewItem::setText(i++,times);//3
    QListViewItem::setText(i++,like);//4
    QListViewItem::setText(i++,sng.getKey().c_str());//5
    QListViewItem::setText(i++,QString::fromLocal8Bit(sng.getFilename().c_str()));//6
    fullpathcolid = 6;
	songkeycolid = 5;
}
