#ifdef __GNUC__
#if __GNUC__ >= 3
#include <sstream>
#else
#include <iostream>
#endif
#endif

#include "lpglobal.h"
#include "absutil.h"
#include "abslog.h"

absLog* globalclass::_logger=0;

void globalclass::setLogger(absLog* logger)
{
		_logger = logger;
}
absLog* globalclass::getLogger()
{
		return _logger;
}
//true: user pressed cancel
bool doSetProgress(int i)
{
	if (globalclass::getLogger())
	return globalclass::getLogger()->progressSet(i);
	else return 0;
}

void logMessage(string text)
{
	if (globalclass::getLogger())
	globalclass::getLogger()->message(text);
}

void doInitProgress(string text, int i)
{
	if (globalclass::getLogger())
	globalclass::getLogger()->progressInit(text, i);
}

void doEndProgress()
{
	if (globalclass::getLogger())
	globalclass::getLogger()->progressEnd();
}
void logDebug(int text)
{
	if (globalclass::getLogger())
	globalclass::getLogger()->debug(text);
}

void logError(string text)
{
	if (globalclass::getLogger())
	globalclass::getLogger()->error(text);
}

void logOops(string text)
{
	if (globalclass::getLogger())
	globalclass::getLogger()->oops(text);
	
}

void logWarning(string text)
{
	if (globalclass::getLogger())
	globalclass::getLogger()->warning(text);
}
void logReady(string text)
{
	if (globalclass::getLogger())
	globalclass::getLogger()->ready(text);
}
void logBusy(string text, bool modal)
{
	if (globalclass::getLogger())
	globalclass::getLogger()->busy(text, modal);
}
void logInfo(string text, int displaylength)
{
	if (globalclass::getLogger())
	globalclass::getLogger()->info(text, displaylength);
}

void logDebug(string text)
{
	if (globalclass::getLogger())
	globalclass::getLogger()->debug(text);
}

void doTest(bool b, string s)
{
	if (!b) logError(string("Test failed: ") + s);
}

void doAssert(bool b, string s)
{
	if (!b) logOops(string("The following runtime error has occurred: ") + s);
}

